/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.util.List;

public class AppInfoUtil {
    public static boolean isRunningForeground(Application application) {
        ActivityManager activityManager = (ActivityManager)application.getSystemService("activity");
        List appProcessInfos = activityManager.getRunningAppProcesses();
        if (appProcessInfos != null && appProcessInfos.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo appProcessInfo : appProcessInfos) {
                if (appProcessInfo.importance != 100 || !appProcessInfo.processName.equals(application.getApplicationInfo().processName)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getAppVersionCode(Context ctx) {
        int localVersion = 0;
        try {
            PackageInfo packageInfo = ctx.getApplicationContext().getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            localVersion = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return localVersion;
    }

    public static String getAppVersionName(Context ctx) {
        String localVersionName = "";
        try {
            PackageInfo packageInfo = ctx.getApplicationContext().getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            localVersionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return localVersionName;
    }
}

