/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.deviceid;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ImeiUtil {
    public static String getImei(Context context) {
        boolean isMatch;
        String imei = null;
        imei = Build.VERSION.SDK_INT <= 20 ? ImeiUtil.getImeiKitkat(context) : (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22 ? ImeiUtil.getImeiLollipop(context) : ImeiUtil.getImeiUpward(context));
        if (TextUtils.isEmpty((CharSequence)imei)) {
            return null;
        }
        boolean bl = isMatch = (imei = imei.toLowerCase()).length() == 15 && Pattern.matches("^[0-9]*$", imei) || imei.length() == 14 && Pattern.matches("^([0-9|a-f|A-F]*)$", imei);
        if (isMatch && !"00000000000000".equals(imei) && !"000000000000000".equals(imei)) {
            return imei;
        }
        return null;
    }

    private static String getImeiKitkat(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return null;
            }
            return manager.getDeviceId();
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds"})
    @TargetApi(value=23)
    private static String getImeiLollipop(Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        Class<?> clazz = null;
        Method method = null;
        try {
            clazz = Class.forName("android.os.SystemProperties");
            method = clazz.getMethod("get", String.class, String.class);
            String gsm = (String)method.invoke(null, "ril.gsm.imei", "");
            String meid = (String)method.invoke(null, "ril.cdma.meid", "");
            map.put("meid", meid);
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                return null;
            }
            String imei1 = null;
            String imei2 = null;
            if (!TextUtils.isEmpty((CharSequence)gsm)) {
                String[] imeiArray = gsm.split(",");
                if (imeiArray != null && imeiArray.length > 0) {
                    imei1 = imeiArray[0];
                    imei2 = imeiArray.length > 1 ? imeiArray[1] : mTelephonyManager.getDeviceId(1);
                } else {
                    imei1 = mTelephonyManager.getDeviceId(0);
                    imei2 = mTelephonyManager.getDeviceId(1);
                }
            } else {
                imei1 = mTelephonyManager.getDeviceId(0);
                imei2 = mTelephonyManager.getDeviceId(1);
            }
            map.put("imei1", imei1);
            map.put("imei2", imei2);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (String)map.get("imei1");
    }

    @TargetApi(value=26)
    private static String getImeiUpward(Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        String imei1 = tm.getImei(0);
        String imei2 = tm.getImei(1);
        if (TextUtils.isEmpty((CharSequence)imei1) && TextUtils.isEmpty((CharSequence)imei2)) {
            map.put("imei1", tm.getMeid());
        } else {
            map.put("imei1", imei1);
            map.put("imei2", imei2);
        }
        return (String)map.get("imei1");
    }
}

