package com.helian.app.deviceid;

import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ImeiUtil {

    public static String getImei(Context context) {
        String imei = null;
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT_WATCH) {
            imei = getImeiKitkat(context);
        } else if (Build.VERSION.SDK_INT == Build.VERSION_CODES.LOLLIPOP
                || Build.VERSION.SDK_INT == Build.VERSION_CODES.LOLLIPOP_MR1) {
            imei = getImeiLollipop(context);
        } else {
            imei = getImeiUpward(context);
        }

        if (TextUtils.isEmpty(imei)) {
            return null;
        }

        imei = imei.toLowerCase();
        boolean isMatch = ((imei.length() == 15 && Pattern.matches("^[0-9]*$", imei))
                || (imei.length() == 14 && Pattern.matches("^([0-9|a-f|A-F]*)$", imei)));
        if (isMatch && !"00000000000000".equals(imei)
                && !"000000000000000".equals(imei)) {
            return imei;
        }
        else {
            return null;
        }
    }

    private static String getImeiKitkat(Context context) {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Activity.TELEPHONY_SERVICE);
        if (manager != null) {
            if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
                return null;
            }
            return manager.getDeviceId();
        }
        return null;
    }

    @SuppressLint("HardwareIds")
    @TargetApi(Build.VERSION_CODES.M)
    private static String getImeiLollipop(Context context) {
        Map<String, String> map = new HashMap<String, String>();
        TelephonyManager mTelephonyManager = (TelephonyManager) context.getSystemService(Activity.TELEPHONY_SERVICE);
        Class<?> clazz = null;
        Method method = null;//(int slotId)

        try {
            clazz = Class.forName("android.os.SystemProperties");
            method = clazz.getMethod("get", String.class, String.class);
            String gsm = (String) method.invoke(null, "ril.gsm.imei", "");
            String meid = (String) method.invoke(null, "ril.cdma.meid", "");
            map.put("meid", meid);

            if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
                return null;
            }

            String imei1 = null;
            String imei2 = null;
            if (!TextUtils.isEmpty(gsm)) {
                //the value of gsm like:xxxxxx,xxxxxx
                String imeiArray[] = gsm.split(",");
                if (imeiArray != null && imeiArray.length > 0) {
                    imei1 = imeiArray[0];
                    if (imeiArray.length > 1) {
                        imei2 = imeiArray[1];
                    } else {
                        imei2 = mTelephonyManager.getDeviceId(1);
                    }
                } else {
                    imei1 = mTelephonyManager.getDeviceId(0);
                    imei2 = mTelephonyManager.getDeviceId(1);
                }
            } else {
                imei1 = mTelephonyManager.getDeviceId(0);
                imei2 = mTelephonyManager.getDeviceId(1);

            }

            map.put("imei1", imei1);
            map.put("imei2", imei2);

        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return map.get("imei1");
    }

    @TargetApi(Build.VERSION_CODES.O)
    private static String getImeiUpward(Context context) {
        Map<String, String> map = new HashMap<String, String>();
        TelephonyManager tm = ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE));
        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return null;
        }
        String imei1 = tm.getImei(0);
        String imei2 = tm.getImei(1);
        if(TextUtils.isEmpty(imei1)&&TextUtils.isEmpty(imei2)){
            map.put("imei1", tm.getMeid()); //如果CDMA制式手机返回MEID
        }else {
            map.put("imei1", imei1);

            map.put("imei2", imei2);
        }
        return map.get("imei1");
    }
}
