/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.deviceid;

import android.content.Context;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.widget.Toast;
import com.helian.app.api.Api;
import com.helian.app.deviceid.FileUtil;
import com.helian.app.deviceid.ImeiUtil;
import com.helian.app.deviceid.ImsiUtil;
import com.helian.app.deviceid.MacUtil;
import com.helian.app.deviceid.api.DeviceService;
import com.helian.app.deviceid.api.bean.DeviceIdBean;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DeviceIdManager {
    private static final String PATH = Environment.getExternalStorageDirectory().toString() + File.separator + "com.helian.device";
    private static final String FILE_NAME = "device.txt";
    private static final String MAC_KEY = "mac";
    private static final String IMSI_KEY = "imsi";
    private static final String IMEI_KEY = "imei";
    private static final String DEVICE_ID_KEY = "device_id";
    private static DeviceIdManager mDeviceIdManager;
    private Context mContext;
    private Api mApi;
    private File mFile;
    private boolean mIsDebug;

    public static DeviceIdManager getInstance() {
        if (mDeviceIdManager == null) {
            mDeviceIdManager = new DeviceIdManager();
        }
        return mDeviceIdManager;
    }

    public void setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
    }

    private String getBaseUrl() {
        if (this.mIsDebug) {
            return "http://usercentretest.hz.taeapp.com/api/";
        }
        return "https://doctor.helianhealth.com/api/";
    }

    public void init(final Context context) {
        this.mContext = context.getApplicationContext();
        this.initFile(context);
        String mac = MacUtil.getMac(context);
        String imei = ImeiUtil.getImei(context);
        String imsi = ImsiUtil.getImsi(context);
        String deviceId = this.getRandomDeviceId();
        if (this.mFile.exists()) {
            String json = FileUtil.read(this.mFile.getAbsolutePath());
            if (!TextUtils.isEmpty((CharSequence)json)) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(MAC_KEY) && TextUtils.isEmpty((CharSequence)mac)) {
                        mac = jsonObject.getString(MAC_KEY);
                    }
                    if (jsonObject.has(IMEI_KEY) && TextUtils.isEmpty((CharSequence)imei)) {
                        imei = jsonObject.getString(IMEI_KEY);
                    }
                    if (jsonObject.has(IMSI_KEY) && TextUtils.isEmpty((CharSequence)imsi)) {
                        imsi = jsonObject.getString(IMSI_KEY);
                    }
                    if (jsonObject.has(DEVICE_ID_KEY)) {
                        deviceId = jsonObject.getString(DEVICE_ID_KEY);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.write(deviceId, mac, imei, imsi, this.mFile);
        }
        if (this.mApi == null) {
            this.mApi = Api.getInitialize().init(this.getBaseUrl(), 0, 15, false).build();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dvc_id", deviceId);
        map.put("os", "1");
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = "";
        }
        map.put(IMEI_KEY, imei);
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            imsi = "";
        }
        map.put(IMSI_KEY, imsi);
        if (TextUtils.isEmpty((CharSequence)mac)) {
            mac = "";
        }
        map.put(MAC_KEY, mac);
        final String finalImsi = imsi;
        final String finalMac = mac;
        final String finalImei = imei;
        ((DeviceService)this.mApi.getService(DeviceService.class)).syncDevice(map).enqueue((Callback)new Callback<DeviceIdBean>(){

            public void onResponse(Call<DeviceIdBean> call, Response<DeviceIdBean> response) {
                try {
                    DeviceIdBean bean = (DeviceIdBean)response.body();
                    if (bean == null || !"10000".equals(bean.getCode())) {
                        Toast.makeText((Context)context, (CharSequence)(bean == null ? "bean is null" : bean.toString()), (int)0).show();
                        return;
                    }
                    DeviceIdManager.this.write(bean.getBizContent(), finalMac, finalImei, finalImsi, DeviceIdManager.this.mFile);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }

            public void onFailure(Call<DeviceIdBean> call, Throwable t) {
                t.fillInStackTrace();
            }
        });
    }

    private void initFile(Context context) {
        this.mFile = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 ? new File(context.getCacheDir(), FILE_NAME) : new File(PATH, FILE_NAME);
    }

    public String getDeviceId() {
        String json;
        this.initFile(this.mContext);
        String deviceId = null;
        if (this.mFile.exists() && !TextUtils.isEmpty((CharSequence)(json = FileUtil.read(this.mFile.getAbsolutePath())))) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                if (jsonObject.has(DEVICE_ID_KEY)) {
                    deviceId = jsonObject.getString(DEVICE_ID_KEY);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = this.getRandomDeviceId();
            this.write(deviceId, null, null, null, this.mFile);
        }
        return deviceId;
    }

    private String getRandomDeviceId() {
        return "L_A_" + UUID.randomUUID().toString().toUpperCase();
    }

    private void write(String deviceId, String mac, String imei, String imsi, File file) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(DEVICE_ID_KEY, (Object)deviceId);
            jsonObject.put(MAC_KEY, (Object)mac);
            jsonObject.put(IMEI_KEY, (Object)imei);
            jsonObject.put(IMSI_KEY, (Object)imsi);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        FileUtil.write(file.getAbsolutePath(), jsonObject.toString());
    }
}

