/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.iface.IHasReader;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.io.streamprovider.StringInputStreamProvider;
import com.helger.base.io.streamprovider.StringReaderProvider;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSSCharsetDetector;
import com.helger.css.parser.ParserCSSCharsetDetectorTokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSReader.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new LoggingCSSParseErrorHandler();
    @GuardedBy(value="RW_LOCK")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="RW_LOCK")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReader INSTANCE = new CSSReader();

    private CSSReader() {
    }

    public static @Nullable ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return (ICSSParseErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        });
    }

    public static @NonNull ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return (ICSSParseExceptionCallback)RW_LOCK.readLockedGet(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@NonNull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionCallback, (String)"DefaultParseExceptionHandler");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
        });
    }

    public static @NonNull ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return (ICSSInterpretErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@NonNull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"DefaultErrorHandler");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = iCSSInterpretErrorHandler;
        });
    }

    private static @Nullable CSSNode _readStyleSheet(@NonNull CharStream charStream, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @NonNull ICSSParseExceptionCallback iCSSParseExceptionCallback, boolean bl, boolean bl2) {
        try {
            ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
            parserCSS30TokenManager.setCustomErrorHandler(iCSSParseErrorHandler);
            ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
            parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
            parserCSS30.setBrowserCompliantMode(bl);
            parserCSS30.setKeepDeprecatedProperties(bl2);
            return parserCSS30.styleSheet();
        }
        catch (ParseException parseException) {
            iCSSParseExceptionCallback.onException(parseException);
            return null;
        }
        catch (Exception exception) {
            iCSSParseExceptionCallback.onException(new ParseException(exception.getMessage()));
            return null;
        }
    }

    public static boolean isValidCSS(@NonNull File file, @NonNull Charset charset) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), charset);
    }

    public static boolean isValidCSS(@NonNull IReadableResource iReadableResource, @NonNull Charset charset) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            LOGGER.warn("Failed to open CSS reader " + String.valueOf(iReadableResource));
            return false;
        }
        return CSSReader.isValidCSS(reader);
    }

    public static boolean isValidCSS(@WillClose @NonNull InputStream inputStream, @NonNull Charset charset) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        return CSSReader.isValidCSS(StreamHelper.createReader((InputStream)inputStream, (Charset)charset));
    }

    public static boolean isValidCSS(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@WillClose @NonNull Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReader._readStyleSheet(cSSCharStream, CSSReader.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback(), false, false);
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings());
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @NonNull Charset charset) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @NonNull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    public static @Nullable CascadingStyleSheet readFromStringStream(@NonNull String string, @NonNull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IHasInputStream)new StringInputStreamProvider(string, cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    public static @Nullable CascadingStyleSheet readFromStringReader(@NonNull String string, @NonNull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromReader((IHasReader)new StringReaderProvider(string), cSSReaderSettings);
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromString(@NonNull String string, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file) {
        return CSSReader.readFromFile(file, new CSSReaderSettings());
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file, @NonNull Charset charset) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file, @NonNull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    public static @Nullable CascadingStyleSheet readFromFile(@NonNull File file, @NonNull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IHasInputStream)new FileSystemResource(file), cSSReaderSettings);
    }

    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings());
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream, @NonNull Charset charset) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    public static @Nullable Charset getCharsetDeclaredInCSS(@NonNull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)inputStream);
        Charset charset = inputStreamAndCharset.getCharset();
        Charset charset2 = charset;
        if (charset2 == null) {
            charset2 = StandardCharsets.ISO_8859_1;
        }
        InputStreamReader inputStreamReader = StreamHelper.createReader((InputStream)inputStreamAndCharset.getInputStream(), (Charset)charset2);
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ParserCSSCharsetDetectorTokenManager parserCSSCharsetDetectorTokenManager = new ParserCSSCharsetDetectorTokenManager(cSSCharStream);
            ParserCSSCharsetDetector parserCSSCharsetDetector = new ParserCSSCharsetDetector(parserCSSCharsetDetectorTokenManager);
            String string = parserCSSCharsetDetector.styleSheetCharset().getText();
            if (string == null) {
                Charset charset3 = charset;
                return charset3;
            }
            String string2 = CSSParseHelper.extractStringValue(string);
            Charset charset4 = CharsetHelper.getCharsetFromName((String)string2);
            if (charset != null && !charset.equals(charset4)) {
                LOGGER.warn("The charset found in the CSS data (" + charset4.name() + ") differs from the charset determined by the BOM (" + charset.name() + ") -> Using the read charset");
            }
            Charset charset5 = charset4;
            return charset5;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to parse CSS charset definition", exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStreamReader);
        }
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream, @NonNull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream, @NonNull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable CascadingStyleSheet readFromStream(@NonNull IHasInputStream iHasInputStream, @NonNull CSSReaderSettings cSSReaderSettings) {
        Charset charset;
        Charset charset2;
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        try {
            charset2 = CSSReader.getCharsetDeclaredInCSS(iHasInputStream);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (charset2 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reading CSS definition again with explicit charset '" + charset2.name() + "'");
            }
            charset = charset2;
        } else {
            charset = cSSReaderSettings.getFallbackCharset();
        }
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)inputStream);
        InputStream inputStream2 = inputStreamAndCharset.getInputStream();
        InputStreamReader inputStreamReader = StreamHelper.createReader((InputStream)inputStream2, (Charset)charset);
        try {
            boolean bl;
            boolean bl2;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            cSSCharStream.setTabSize(cSSReaderSettings.getTabSize());
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl2 = cSSReaderSettings.isBrowserCompliantMode(), bl = cSSReaderSettings.isKeepDeprecatedProperties())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            boolean bl3 = cSSReaderSettings.isUseSourceLocation();
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(iCSSInterpretErrorHandler, bl3, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStreamReader);
        }
    }

    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static @Nullable CascadingStyleSheet readFromReader(@NonNull IHasReader iHasReader, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromReader(iHasReader, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable CascadingStyleSheet readFromReader(@NonNull IHasReader iHasReader, @NonNull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)iHasReader, (String)"ReaderProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        Reader reader = iHasReader.getReader();
        if (reader == null) {
            return null;
        }
        try {
            boolean bl;
            boolean bl2;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            cSSCharStream.setTabSize(cSSReaderSettings.getTabSize());
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl2 = cSSReaderSettings.isBrowserCompliantMode(), bl = cSSReaderSettings.isKeepDeprecatedProperties())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            boolean bl3 = cSSReaderSettings.isUseSourceLocation();
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(iCSSInterpretErrorHandler, bl3, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }
}

