/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSMultiValue;
import org.jspecify.annotations.NonNull;

@Immutable
public class CSSValueMultiValue
implements ICSSMultiValue {
    private final ICommonsList<CSSValue> m_aValues = new CommonsArrayList();

    public CSSValueMultiValue(@NonNull ICSSProperty iCSSProperty, @Nonempty @NonNull String[] stringArray, boolean bl) {
        ValueEnforcer.notNull((Object)iCSSProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"Values");
        for (String string : stringArray) {
            this.m_aValues.add((Object)new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSValue> getAllContainedValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    public @NonNull ECSSProperty getProp() {
        return ((CSSValue)this.m_aValues.getFirstOrNull()).getProp();
    }

    @Override
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringImplode.imploder().source(this.m_aValues, cSSValue -> cSSValue.getAsCSSString(iCSSWriterSettings, n)).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValueMultiValue cSSValueMultiValue = (CSSValueMultiValue)object;
        return this.m_aValues.equals(cSSValueMultiValue.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Values", this.m_aValues).getToString();
    }
}

