/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.annotation.Nonempty;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(73),
    UNKNOWNRULEPARAMETERLIST(71),
    UNKNOWNRULEBODY(72),
    STYLERULE(44),
    IMPORTRULE(16),
    PAGERULE(55),
    MEDIARULE(51),
    LAYERRULE(59),
    FONTFACERULE(60),
    SELECTOR(39),
    RELATIVESELECTOR(32),
    STYLEDECLARATIONLIST(43),
    STYLEDECLARATION(42),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(36),
    HOST(29),
    HOSTCONTEXT(30),
    SLOTTED(31),
    NEGATION(37),
    PSEUDO_HAS(33),
    PSEUDO_IS(34),
    PSEUDO_WHERE(35),
    ATTRIB(27),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    ATTRIBCASE(26),
    SELECTORCOMBINATOR(38),
    NTH(28),
    PROPERTY(40),
    IMPORTANT(41),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    CALC(9),
    CALCSUMOPERATOR(8),
    CALCPRODUCT(7),
    CALCPRODUCTOPERATOR(6),
    CALCUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(50),
    MEDIUM(46),
    MEDIAQUERY(49),
    MEDIAMODIFIER(45),
    MEDIAEXPR(48),
    MEDIAFEATURE(47),
    LAYERSELECTOR(56),
    LAYERSELECTORLIST(57),
    LAYERRULEBLOCK(58),
    PSEUDOPAGE(-1),
    PAGESELECTOR(52),
    PAGEMARGINSYMBOL(53),
    PAGERULEBLOCK(54),
    KEYFRAMESRULE(64),
    KEYFRAMESIDENTIFIER(61),
    KEYFRAMESSELECTOR(63),
    SINGLEKEYFRAMESELECTOR(62),
    VIEWPORTRULE(65),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(70),
    SUPPORTSCONDITION(69),
    SUPPORTSCONDITIONOPERATOR(68),
    SUPPORTSNEGATION(67),
    SUPPORTSCONDITIONINPARENS(66),
    ERROR_SKIPTO(1);

    private static final Logger LOGGER;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType() {
        return this.m_nParserType30;
    }

    public boolean isNode(@NonNull CSSNode cSSNode) {
        return cSSNode.getNodeType() == this.getParserNodeType();
    }

    @NonNull String getNodeName() {
        return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
    }

    static @Nullable ECSSNodeType getNodeType(@NonNull CSSNode cSSNode) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    static @Nullable String getNodeName(@NonNull CSSNode cSSNode) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName();
        }
        LOGGER.warn("Unsupported node type " + cSSNode.getNodeType());
        return null;
    }

    private static void _dumpRecursive(@NonNull CSSNode cSSNode, @NonNull StringBuilder stringBuilder, @NonNull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode));
        if (cSSNode.isNotEmpty()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, stringBuilder, string + "  ");
        }
    }

    @Nonempty
    public static @NonNull String getDump(@NonNull CSSNode cSSNode) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@NonNull CSSNode cSSNode) {
        return ERROR_SKIPTO.isNode(cSSNode);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

