/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.CSSNodeToDomainObject;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.parser.CSSNode;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import org.jspecify.annotations.NonNull;

@Immutable
public final class CSSHandler {
    public static final boolean DEFAULT_USE_SOURCE_LOCATION = true;
    private static final CSSHandler INSTANCE = new CSSHandler();

    private CSSHandler() {
    }

    public static @NonNull CascadingStyleSheet readCascadingStyleSheetFromNode(@NonNull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @NonNull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(iCSSInterpretErrorHandler, bl).createCascadingStyleSheetFromNode(cSSNode);
    }

    public static @NonNull CSSDeclarationList readDeclarationListFromNode(@NonNull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @NonNull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(iCSSInterpretErrorHandler, bl).createDeclarationListFromNode(cSSNode);
    }
}

