/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.IHasCSSDeclarations;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations<CSSStyleRule>,
ICSSSourceLocationAware {
    private final ICommonsList<CSSSelector> m_aSelectors = new CommonsArrayList();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSelectors() {
        return this.m_aSelectors.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aSelectors.size();
    }

    public @NonNull CSSStyleRule addSelector(@NonNull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(iCSSSelectorMember));
    }

    public @NonNull CSSStyleRule addSelector(@NonNull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        this.m_aSelectors.add((Object)cSSSelector);
        return this;
    }

    public @NonNull CSSStyleRule addSelector(@Nonnegative int n, @NonNull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(n, new CSSSelector().addMember(iCSSSelectorMember));
    }

    public @NonNull CSSStyleRule addSelector(@Nonnegative int n, @NonNull CSSSelector cSSSelector) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        if (n >= this.getSelectorCount()) {
            this.m_aSelectors.add((Object)cSSSelector);
        } else {
            this.m_aSelectors.add(n, (Object)cSSSelector);
        }
        return this;
    }

    public @NonNull EChange removeSelector(@NonNull CSSSelector cSSSelector) {
        return this.m_aSelectors.removeObject((Object)cSSSelector);
    }

    public @NonNull EChange removeSelector(@Nonnegative int n) {
        return this.m_aSelectors.removeAtIndex(n);
    }

    public @NonNull EChange removeAllSelectors() {
        return this.m_aSelectors.removeAll();
    }

    public @Nullable CSSSelector getSelectorAtIndex(@Nonnegative int n) {
        return (CSSSelector)this.m_aSelectors.getAtIndex(n);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSSelector> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Override
    public @NonNull CSSStyleRule addDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    public @NonNull CSSStyleRule addDeclaration(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    public @NonNull EChange removeDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    public @NonNull EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    public @NonNull EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    public @Nullable CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    public @NonNull CSSStyleRule setDeclarationAtIndex(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    public @Nullable CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    public @NonNull String getSelectorsAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (CSSSelector cSSSelector : this.m_aSelectors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString()).append(iCSSWriterSettings.getIndent(n));
                }
            }
            stringBuilder.append(cSSSelector.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSelectorsAsCSSString(iCSSWriterSettings, n));
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSStyleRule cSSStyleRule = (CSSStyleRule)object;
        return this.m_aSelectors.equals(cSSStyleRule.m_aSelectors) && this.m_aDeclarations.equals(cSSStyleRule.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

