/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ECSSAttributeCase;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ICSSSelectorMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSSelectorAttribute
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sNamespacePrefix;
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;
    private final ECSSAttributeCase m_eAttrCase;
    private CSSSourceLocation m_aSourceLocation;

    private static boolean _isValidNamespacePrefix(@Nullable String string) {
        return StringHelper.isEmpty((String)string) || string.endsWith("|");
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonempty @NonNull String string2) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("NamespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"AttrName");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
        this.m_eAttrCase = null;
    }

    @Deprecated(forRemoval=true, since="8.0.1")
    public CSSSelectorAttribute(@Nullable String string, @Nonempty @NonNull String string2, @NonNull ECSSAttributeOperator eCSSAttributeOperator, @NonNull String string3) {
        this(string, string2, eCSSAttributeOperator, string3, null);
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonempty @NonNull String string2, @NonNull ECSSAttributeOperator eCSSAttributeOperator, @NonNull String string3, @Nullable ECSSAttributeCase eCSSAttributeCase) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("NamespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"AttrName");
        ValueEnforcer.notNull((Object)eCSSAttributeOperator, (String)"Operator");
        ValueEnforcer.notNull((Object)string3, (String)"AttrValue");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = eCSSAttributeOperator;
        this.m_sAttrValue = string3;
        this.m_eAttrCase = eCSSAttributeCase;
    }

    public @Nullable String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonempty
    public @NonNull String getAttrName() {
        return this.m_sAttrName;
    }

    public @Nullable ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    public @Nullable String getAttrValue() {
        return this.m_sAttrValue;
    }

    public @Nullable ECSSAttributeCase getCaseSensitivityFlag() {
        return this.m_eAttrCase;
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (StringHelper.isNotEmpty((String)this.m_sNamespacePrefix)) {
            stringBuilder.append(this.m_sNamespacePrefix);
        }
        stringBuilder.append(this.m_sAttrName);
        if (this.m_eOperator != null) {
            stringBuilder.append(this.m_eOperator.getAsCSSString(iCSSWriterSettings, n)).append(this.m_sAttrValue);
            if (this.m_eAttrCase != null) {
                stringBuilder.append(' ').append(this.m_eAttrCase.getName());
            }
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorAttribute cSSSelectorAttribute = (CSSSelectorAttribute)object;
        return EqualsHelper.equals((Object)this.m_sNamespacePrefix, (Object)cSSSelectorAttribute.m_sNamespacePrefix) && this.m_sAttrName.equals(cSSSelectorAttribute.m_sAttrName) && EqualsHelper.equals((Object)this.m_eOperator, (Object)cSSSelectorAttribute.m_eOperator) && EqualsHelper.equals((Object)this.m_sAttrValue, (Object)cSSSelectorAttribute.m_sAttrValue) && EqualsHelper.equals((Object)this.m_eAttrCase, (Object)cSSSelectorAttribute.m_eAttrCase);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sNamespacePrefix).append((Object)this.m_sAttrName).append((Object)this.m_eOperator).append((Object)this.m_sAttrValue).append((Object)this.m_eAttrCase).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("namespacePrefix", (Object)this.m_sNamespacePrefix).append("attrName", (Object)this.m_sAttrName).appendIfNotNull("operator", (Object)this.m_eOperator).appendIfNotNull("attrValue", (Object)this.m_sAttrValue).appendIfNotNull("caseFlag", (Object)this.m_eAttrCase).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

