/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSRGBA
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSRGBA> {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;
    private String m_sOpacity;

    public CSSRGBA(@NonNull CSSRGBA cSSRGBA) {
        this(cSSRGBA.getRed(), cSSRGBA.getGreen(), cSSRGBA.getBlue(), cSSRGBA.getOpacity());
    }

    public CSSRGBA(@NonNull CSSRGB cSSRGB, float f) {
        this(cSSRGB, Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSRGBA(@NonNull CSSRGB cSSRGB, @Nonempty @NonNull String string) {
        this(cSSRGB.getRed(), cSSRGB.getGreen(), cSSRGB.getBlue(), string);
    }

    public CSSRGBA(int n, int n2, int n3, float f) {
        this(Integer.toString(CSSColorHelper.getRGBValue(n)), Integer.toString(CSSColorHelper.getRGBValue(n2)), Integer.toString(CSSColorHelper.getRGBValue(n3)), Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSRGBA(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4) {
        this.setRed(string);
        this.setGreen(string2);
        this.setBlue(string3);
        this.setOpacity(string4);
    }

    @Nonempty
    public final @NonNull String getRed() {
        return this.m_sRed;
    }

    public final @NonNull CSSRGBA setRed(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Red");
        this.m_sRed = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getGreen() {
        return this.m_sGreen;
    }

    public final @NonNull CSSRGBA setGreen(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Green");
        this.m_sGreen = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getBlue() {
        return this.m_sBlue;
    }

    public final @NonNull CSSRGBA setBlue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Blue");
        this.m_sBlue = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getOpacity() {
        return this.m_sOpacity;
    }

    public final @NonNull CSSRGBA setOpacity(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Opacity");
        this.m_sOpacity = string;
        return this;
    }

    public @NonNull CSSRGB getAsRGB() {
        return new CSSRGB(this.m_sRed, this.m_sGreen, this.m_sBlue);
    }

    @Override
    @Nonempty
    public @NonNull String getAsString() {
        return "rgba(" + this.m_sRed + "," + this.m_sGreen + "," + this.m_sBlue + "," + this.m_sOpacity + ")";
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    public @NonNull CSSRGBA getClone() {
        return new CSSRGBA(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRGBA cSSRGBA = (CSSRGBA)object;
        return this.m_sRed.equals(cSSRGBA.m_sRed) && this.m_sGreen.equals(cSSRGBA.m_sGreen) && this.m_sBlue.equals(cSSRGBA.m_sBlue) && this.m_sOpacity.equals(cSSRGBA.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).append((Object)this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).append("opacity", (Object)this.m_sOpacity).getToString();
    }
}

