/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.ICSSTopLevelRule;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final ICommonsList<CSSKeyframesBlock> m_aBlocks = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonempty @NonNull String string) {
        return StringHelper.startsWith((CharSequence)string, (char)'@') && StringHelper.endsWithIgnoreCase((String)string, (String)"keyframes");
    }

    public CSSKeyframesRule(@Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        ValueEnforcer.isTrue((boolean)CSSKeyframesRule.isValidDeclaration(string), (String)"Declaration is invalid");
        this.m_sDeclaration = string;
        this.m_sAnimationName = string2;
    }

    @Nonempty
    public final @NonNull String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonempty
    public final @NonNull String getAnimationName() {
        return this.m_sAnimationName;
    }

    public boolean hasBlocks() {
        return this.m_aBlocks.isNotEmpty();
    }

    @Nonnegative
    public int getBlockCount() {
        return this.m_aBlocks.size();
    }

    public @NonNull CSSKeyframesRule addBlock(@NonNull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.notNull((Object)cSSKeyframesBlock, (String)"KeyframesBlock");
        this.m_aBlocks.add((Object)cSSKeyframesBlock);
        return this;
    }

    public @NonNull CSSKeyframesRule addBlock(@Nonnegative int n, @NonNull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSKeyframesBlock, (String)"KeyframesBlock");
        if (n >= this.getBlockCount()) {
            this.m_aBlocks.add((Object)cSSKeyframesBlock);
        } else {
            this.m_aBlocks.add(n, (Object)cSSKeyframesBlock);
        }
        return this;
    }

    public @NonNull EChange removeBlock(@NonNull CSSKeyframesBlock cSSKeyframesBlock) {
        return this.m_aBlocks.removeObject((Object)cSSKeyframesBlock);
    }

    public @NonNull EChange removeBlock(@Nonnegative int n) {
        return this.m_aBlocks.removeAtIndex(n);
    }

    public @NonNull EChange removeAllBlocks() {
        return this.m_aBlocks.removeAll();
    }

    public @Nullable CSSKeyframesBlock getBlockAtIndex(@Nonnegative int n) {
        return (CSSKeyframesBlock)this.m_aBlocks.getAtIndex(n);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSKeyframesBlock> getAllBlocks() {
        return (ICommonsList)this.m_aBlocks.getClone();
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        stringBuilder.append(' ').append(this.m_sAnimationName).append(bl ? "{" : " {");
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        for (CSSKeyframesBlock cSSKeyframesBlock : this.m_aBlocks) {
            String string = cSSKeyframesBlock.getAsCSSString(iCSSWriterSettings, n + 1);
            if (!StringHelper.isNotEmpty((String)string)) continue;
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(string);
            if (bl) continue;
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getIndent(n));
        }
        stringBuilder.append('}');
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesRule cSSKeyframesRule = (CSSKeyframesRule)object;
        return this.m_sDeclaration.equals(cSSKeyframesRule.m_sDeclaration) && this.m_sAnimationName.equals(cSSKeyframesRule.m_sAnimationName) && this.m_aBlocks.equals(cSSKeyframesRule.m_aBlocks);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sAnimationName).append(this.m_aBlocks).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("animationName", (Object)this.m_sAnimationName).append("blocks", this.m_aBlocks).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

