/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSHSL;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSHSLA
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSHSLA> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;
    private String m_sOpacity;

    public CSSHSLA(@NonNull CSSHSLA cSSHSLA) {
        this(cSSHSLA.getHue(), cSSHSLA.getSaturation(), cSSHSLA.getLightness(), cSSHSLA.getOpacity());
    }

    public CSSHSLA(@NonNull CSSHSL cSSHSL, float f) {
        this(cSSHSL, Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSHSLA(@NonNull CSSHSL cSSHSL, @Nonempty @NonNull String string) {
        this(cSSHSL.getHue(), cSSHSL.getSaturation(), cSSHSL.getLightness(), string);
    }

    public CSSHSLA(int n, int n2, int n3, float f) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(n)), Integer.toString(CSSColorHelper.getHSLPercentageValue(n2)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(n3)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(f)));
    }

    public CSSHSLA(float f, float f2, float f3, float f4) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(f)), Float.toString(CSSColorHelper.getHSLPercentageValue(f2)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(f3)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(f4)));
    }

    public CSSHSLA(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4) {
        this.setHue(string);
        this.setSaturation(string2);
        this.setLightness(string3);
        this.setOpacity(string4);
    }

    @Nonempty
    public final @NonNull String getHue() {
        return this.m_sHue;
    }

    public final @NonNull CSSHSLA setHue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Hue");
        this.m_sHue = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getSaturation() {
        return this.m_sSaturation;
    }

    public final @NonNull CSSHSLA setSaturation(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Saturation");
        this.m_sSaturation = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getLightness() {
        return this.m_sLightness;
    }

    public final @NonNull CSSHSLA setLightness(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Lightness");
        this.m_sLightness = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getOpacity() {
        return this.m_sOpacity;
    }

    public final @NonNull CSSHSLA setOpacity(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Opacity");
        this.m_sOpacity = string;
        return this;
    }

    public @NonNull CSSHSL getAsHSL() {
        return new CSSHSL(this.m_sHue, this.m_sSaturation, this.m_sLightness);
    }

    @Override
    @Nonempty
    public @NonNull String getAsString() {
        return "hsla(" + this.m_sHue + "," + this.m_sSaturation + "," + this.m_sLightness + "," + this.m_sOpacity + ")";
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    public @NonNull CSSHSLA getClone() {
        return new CSSHSLA(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSHSLA cSSHSLA = (CSSHSLA)object;
        return this.m_sHue.equals(cSSHSLA.m_sHue) && this.m_sSaturation.equals(cSSHSLA.m_sSaturation) && this.m_sLightness.equals(cSSHSLA.m_sLightness) && this.m_sOpacity.equals(cSSHSLA.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).append((Object)this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Hue", (Object)this.m_sHue).append("Saturation", (Object)this.m_sSaturation).append("Lightness", (Object)this.m_sLightness).append("Opacity", (Object)this.m_sOpacity).getToString();
    }
}

