/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.css.ECSSUnit;
import org.jspecify.annotations.NonNull;

@Immutable
public final class CSSExpressionTermOptimizer {
    private static final ICommonsSet<String> UNIT_VALUES_0 = new CommonsHashSet();
    private static final CSSExpressionTermOptimizer INSTANCE;

    private CSSExpressionTermOptimizer() {
    }

    @Nonempty
    public static @NonNull String getOptimizedValue(@Nonempty @NonNull String string) {
        if (UNIT_VALUES_0.contains((Object)string)) {
            return "0";
        }
        if (string.length() == 7 && string.charAt(0) == '#' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(4) && string.charAt(5) == string.charAt(6)) {
            return Character.toString('#') + string.charAt(1) + string.charAt(3) + string.charAt(5);
        }
        return string;
    }

    static {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            UNIT_VALUES_0.add((Object)eCSSUnit.format(0));
        }
        INSTANCE = new CSSExpressionTermOptimizer();
    }
}

