/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.ICSSExpressionMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpressionMemberTermURI
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private CSSURI m_aURI;

    public CSSExpressionMemberTermURI(@NonNull String string) {
        this(new CSSURI(string));
    }

    public CSSExpressionMemberTermURI(@NonNull CSSURI cSSURI) {
        this.setURI(cSSURI);
    }

    public final @NonNull CSSURI getURI() {
        return this.m_aURI;
    }

    @Nonempty
    public final @NonNull String getURIString() {
        return this.m_aURI.getURI();
    }

    public final @NonNull CSSExpressionMemberTermURI setURI(@NonNull CSSURI cSSURI) {
        this.m_aURI = (CSSURI)ValueEnforcer.notNull((Object)cSSURI, (String)"URI");
        return this;
    }

    public final @NonNull CSSExpressionMemberTermURI setURIString(@NonNull String string) {
        this.m_aURI.setURI(string);
        return this;
    }

    public @NonNull CSSExpressionMemberTermURI getClone() {
        return new CSSExpressionMemberTermURI(this.m_aURI);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_aURI.getAsCSSString(iCSSWriterSettings, n);
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aURI.getSourceLocation();
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aURI.setSourceLocation(cSSSourceLocation);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)object;
        return this.m_aURI.equals(cSSExpressionMemberTermURI.m_aURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("URI", (Object)this.m_aURI).getToString();
    }
}

