/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class CSSFilenameHelper {
    private static final CSSFilenameHelper INSTANCE = new CSSFilenameHelper();

    private CSSFilenameHelper() {
    }

    public static boolean isCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((String)string, (String)".css");
    }

    public static boolean isMinifiedCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((String)string, (String)".min.css");
    }

    public static boolean isRegularCSSFilename(@Nullable String string) {
        return CSSFilenameHelper.isCSSFilename(string) && !CSSFilenameHelper.isMinifiedCSSFilename(string);
    }

    public static @NonNull String getMinifiedCSSFilename(@NonNull String string) {
        ValueEnforcer.isTrue((boolean)CSSFilenameHelper.isCSSFilename(string), (String)("Passed file name '" + string + "' is not a CSS file name!"));
        if (CSSFilenameHelper.isMinifiedCSSFilename(string)) {
            return string;
        }
        return StringHelper.trimEnd((String)string, (String)".css") + ".min.css";
    }
}

