/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.ICSSTopLevelRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSPageRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aSelectors;
    private final CSSWritableList<ICSSPageRuleMember> m_aMembers = new CSSWritableList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSPageRule(@Nullable String string) {
        this.m_aSelectors = StringHelper.isNotEmpty((String)string) ? new CommonsArrayList((Object)string) : new CommonsArrayList();
    }

    public CSSPageRule(@Nonnull Iterable<String> iterable) {
        ValueEnforcer.notNullNoNullValue(iterable, (String)"Selectors");
        this.m_aSelectors = new CommonsArrayList(iterable);
    }

    @Nonnull
    public ICommonsList<String> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Nonnull
    public CSSPageRule addMember(@Nonnull ICSSPageRuleMember iCSSPageRuleMember) {
        this.m_aMembers.add(iCSSPageRuleMember);
        return this;
    }

    @Nonnull
    public CSSPageRule addMember(@Nonnegative int n, @Nonnull ICSSPageRuleMember iCSSPageRuleMember) {
        this.m_aMembers.add(n, iCSSPageRuleMember);
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSPageRuleMember iCSSPageRuleMember) {
        return this.m_aMembers.removeObject(iCSSPageRuleMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSPageRuleMember> getAllMembers() {
        return this.m_aMembers.getClone();
    }

    @Nullable
    public ICSSPageRuleMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSPageRuleMember)this.m_aMembers.getAtIndex(n);
    }

    @Nonnull
    public CSSPageRule setMemberAtIndex(@Nonnegative int n, @Nonnull ICSSPageRuleMember iCSSPageRuleMember) {
        this.m_aMembers.set(n, iCSSPageRuleMember);
        return this;
    }

    public boolean hashMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        int n2;
        if (!iCSSWriterSettings.isWritePageRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.m_aMembers.isEmpty()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder("@page");
        if (this.m_aSelectors.isNotEmpty()) {
            stringBuilder.append(' ');
            n2 = 1;
            for (String string : this.m_aSelectors) {
                if (n2 != 0) {
                    n2 = 0;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append(string);
            }
        }
        if ((n2 = this.m_aMembers.size()) == 0) {
            stringBuilder.append(bl ? "{}" : " {}");
        } else if (n2 == 1) {
            stringBuilder.append(bl ? "{" : " { ");
            stringBuilder.append(this.m_aMembers.getAsCSSString(iCSSWriterSettings, n));
            stringBuilder.append(bl ? "}" : " }");
        } else {
            stringBuilder.append((String)(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString()));
            stringBuilder.append(this.m_aMembers.getAsCSSString(iCSSWriterSettings, n));
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
        }
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSPageRule cSSPageRule = (CSSPageRule)object;
        return this.m_aMembers.equals(cSSPageRule.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

