/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.media.ECSSMediaExpressionFeature;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSMediaExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final String m_sFeature;
    private final CSSExpression m_aValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature) {
        this(eCSSMediaExpressionFeature.getName());
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eCSSMediaExpressionFeature, @Nullable CSSExpression cSSExpression) {
        this(eCSSMediaExpressionFeature.getName(), cSSExpression);
    }

    public CSSMediaExpression(@Nonnull @Nonempty String string, @Nullable CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Feature");
        this.m_sFeature = string;
        this.m_aValue = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public final String getFeature() {
        return this.m_sFeature;
    }

    @Nullable
    public final CSSExpression getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.m_sFeature);
        if (this.m_aValue != null) {
            stringBuilder.append(':').append(this.m_aValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaExpression cSSMediaExpression = (CSSMediaExpression)object;
        return this.m_sFeature.equals(cSSMediaExpression.m_sFeature) && EqualsHelper.equals((Object)this.m_aValue, (Object)cSSMediaExpression.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFeature).append((Object)this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("feature", (Object)this.m_sFeature).appendIfNotNull("value", (Object)this.m_aValue).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

