/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.IHasCSSDeclarations;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSKeyframesBlock
implements IHasCSSDeclarations<CSSKeyframesBlock>,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aKeyframesSelectors;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSKeyframesBlock(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList((Object[])stringArray);
    }

    public CSSKeyframesBlock(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllKeyframesSelectors() {
        return (ICommonsList)this.m_aKeyframesSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.m_aKeyframesSelectors) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesBlock cSSKeyframesBlock = (CSSKeyframesBlock)object;
        return this.m_aKeyframesSelectors.equals(cSSKeyframesBlock.m_aKeyframesSelectors) && this.m_aDeclarations.equals(cSSKeyframesBlock.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aKeyframesSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyframesSelectors", this.m_aKeyframesSelectors).append("Declarations", (Object)this.m_aDeclarations).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

