/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionTermOptimizer;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberTermSimple
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private String m_sValue;
    private String m_sOptimizedValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberTermSimple(int n) {
        this(Integer.toString(n));
    }

    public CSSExpressionMemberTermSimple(long l) {
        this(Long.toString(l));
    }

    public CSSExpressionMemberTermSimple(float f) {
        this(Float.toString(f));
    }

    public CSSExpressionMemberTermSimple(double d) {
        this(Double.toString(d));
    }

    public CSSExpressionMemberTermSimple(@Nonnull @Nonempty String string) {
        this.setValue(string);
    }

    @Nonnull
    public CSSExpressionMemberTermSimple setValue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
        this.m_sOptimizedValue = CSSExpressionTermOptimizer.getOptimizedValue(string);
        return this;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @Nonempty
    public String getOptimizedValue() {
        return this.m_sOptimizedValue;
    }

    @Nonnull
    public CSSExpressionMemberTermSimple getClone() {
        return new CSSExpressionMemberTermSimple(this.m_sValue);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return iCSSWriterSettings.isOptimizedOutput() ? this.m_sOptimizedValue : this.m_sValue;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = (CSSExpressionMemberTermSimple)object;
        return this.m_sOptimizedValue.equals(cSSExpressionMemberTermSimple.m_sOptimizedValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sOptimizedValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).append("optimizedValue", (Object)this.m_sOptimizedValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

