/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSMediaExpressionFeature implements IHasName
{
    WIDTH("width"),
    MIN_WIDTH("min-width"),
    MAX_WIDTH("max-width"),
    HEIGHT("height"),
    MIN_HEIGHT("min-height"),
    MAX_HEIGHT("max-height"),
    DEVICE_WIDTH("device-width"),
    MIN_DEVICE_WIDTH("min-device-width"),
    MAX_DEVICE_WIDTH("max-device-width"),
    DEVICE_HEIGHT("device-height"),
    MIN_DEVICE_HEIGHT("min-device-height"),
    MAX_DEVICE_HEIGHT("max-device-height"),
    ORIENTATION("orientation"),
    ASPECT_RATIO("aspect-ratio"),
    MIN_ASPECT_RATIO("min-aspect-ratio"),
    MAX_ASPECT_RATIO("max-aspect-ratio"),
    DEVICE_ASPECT_RATIO("device-aspect-ratio"),
    MIN_DEVICE_ASPECT_RATIO("min-device-aspect-ratio"),
    MAX_DEVICE_ASPECT_RATIO("max-device-aspect-ratio"),
    COLOR("color"),
    MIN_COLOR("min-color"),
    MAX_COLOR("max-color"),
    COLOR_INDEX("color-index"),
    MIN_COLOR_INDEX("min-color-index"),
    MAX_COLOR_INDEX("max-color-index"),
    MONOCHROME("monochrome"),
    MIN_MONOCHROME("min-monochrome"),
    MAX_MONOCHROME("max-monochrome"),
    RESOLUTION("resolution"),
    MIN_RESOLUTION("min-resolution"),
    MAX_RESOLUTION("max-resolution"),
    SCAN("scan"),
    GRID("grid"),
    MAX_DEVICE_PIXEL_RATIO("max-device-pixel-ratio"),
    MIN_DEVICE_PIXEL_RATIO("min-device-pixel-ratio"),
    TRANSFORM_3D("transform-3d"),
    LIGHT_LEVEL("light-level"),
    ENVIRONMENT_BLENDING("environment-blending"),
    INVERTED_COLORS("inverted-colors"),
    PREFERS_REDUCED_MOTION("prefers-reduced-motion"),
    PREFERS_REDUCED_TRANSPARENCY("prefers-reduced-transparency"),
    PREFERS_CONTRAST("prefers-contrast"),
    PREFERS_COLOR_SCHEME("prefers-color-scheme"),
    _WEBKIT_DEVICE_PIXEL_RATIO("-webkit-device-pixel-ratio"),
    _WEBKIT_MAX_DEVICE_PIXEL_RATIO("-webkit-max-device-pixel-ratio"),
    _WEBKIT_MIN_DEVICE_PIXEL_RATIO("-webkit-min-device-pixel-ratio"),
    _WEBKIT_TRANSFORM_3D("-webkit-transform-3d"),
    _MS_HIGH_CONTRAST("-ms-high-contrast"),
    _MS_VIEW_STATE("-ms-view-state"),
    _MOZ_MAX_DEVICE_PIXEL_RATIO("-moz-max-device-pixel-ratio"),
    _MOZ_MIN_DEVICE_PIXEL_RATIO("-moz-min-device-pixel-ratio"),
    MAX_MOZ_DEVICE_PIXEL_RATION("max--moz-device-pixel-ratio"),
    MIN_MOZ_DEVICE_PIXEL_RATION("min--moz-device-pixel-ratio"),
    _MOZ_IMAGES_IN_MENUS("-moz-images-in-menus"),
    _MOZ_MAC_GRAPHITE_THEME("-moz-mac-graphite-theme"),
    _MOZ_MAEMO_CLASSIC("-moz-maemo-classic"),
    _MOZ_DEVICE_PIXEL_RATIO("-moz-device-pixel-ratio"),
    _MOZ_OS_VERSION("-moz-os-version"),
    _MOZ_SCROLLBAR_END_BACKWARD("-moz-scrollbar-end-backward"),
    _MOZ_SCROLLBAR_END_FORWARD("-moz-scrollbar-end-forward"),
    _MOZ_SCROLLBAR_START_BACKWARD("-moz-scrollbar-start-backward"),
    _MOZ_SCROLLBAR_START_FORWARD("-moz-scrollbar-start-forward"),
    _MOZ_SCROLLBAR_THUMB_PROPORTIONAL("-moz-scrollbar-thumb-proportional"),
    _MOZ_TOUCH_ENABLED("-moz-touch-enabled"),
    _MOZ_WINDOWS_CLASSIC("-moz-windows-classic"),
    _MOZ_WINDOWS_COMPOSITOR("-moz-windows-compositor"),
    _MOZ_WINDOWS_DEFAULT_THEME("-moz-windows-default-theme"),
    _MOZ_WINDOWS_GLASS("-moz-windows-glass"),
    _MOZ_WINDOWS_THEME("-moz-windows-theme");

    private final String m_sName;

    private ECSSMediaExpressionFeature(String string2) {
        this.m_sName = string2;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean isWebkitSpecific() {
        return this.m_sName.startsWith("-webkit-");
    }

    public boolean isMozillaSpecific() {
        return this.m_sName.contains("-moz-");
    }

    public boolean isMicrosoftSpecific() {
        return this.m_sName.startsWith("-ms-");
    }

    public boolean isBrowserSpecific() {
        return this.m_sName.startsWith("-") || this.m_sName.contains("--");
    }

    @Nullable
    public static ECSSMediaExpressionFeature getFromNameOrNull(@Nullable String string) {
        return (ECSSMediaExpressionFeature)EnumHelper.getFromNameOrNull(ECSSMediaExpressionFeature.class, (String)string);
    }
}

