/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSTopLevelRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CascadingStyleSheet
implements ICSSSourceLocationAware,
Serializable {
    private final List<CSSImportRule> m_aImportRules = new ArrayList<CSSImportRule>();
    private final List<CSSNamespaceRule> m_aNamespaceRules = new ArrayList<CSSNamespaceRule>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return !this.m_aImportRules.isEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int n) {
        return (CSSImportRule)CollectionHelper.getSafe(this.m_aImportRules, (int)n);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        this.m_aImportRules.add(cSSImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int n, @Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        if (n >= this.getImportRuleCount()) {
            this.m_aImportRules.add(cSSImportRule);
        } else {
            this.m_aImportRules.add(n, cSSImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule cSSImportRule) {
        return EChange.valueOf((boolean)this.m_aImportRules.remove(cSSImportRule));
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aImportRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllImportRules() {
        if (this.m_aImportRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSImportRule> getAllImportRules() {
        return CollectionHelper.newList(this.m_aImportRules);
    }

    public boolean hasNamespaceRules() {
        return !this.m_aNamespaceRules.isEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int n) {
        return (CSSNamespaceRule)CollectionHelper.getSafe(this.m_aNamespaceRules, (int)n);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        this.m_aNamespaceRules.add(cSSNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int n, @Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        if (n >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add(cSSNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(n, cSSNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule cSSNamespaceRule) {
        return EChange.valueOf((boolean)this.m_aNamespaceRules.remove(cSSNamespaceRule));
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aNamespaceRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aNamespaceRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        if (this.m_aNamespaceRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aNamespaceRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSNamespaceRule> getAllNamespaceRules() {
        return CollectionHelper.newList(this.m_aNamespaceRules);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nullable
    public ICSSTopLevelRule getRuleAtIndex(@Nonnegative int n) {
        return (ICSSTopLevelRule)CollectionHelper.getSafe(this.m_aRules, (int)n);
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        this.m_aRules.add(iCSSTopLevelRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add(iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, iCSSTopLevelRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllRules() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return CollectionHelper.newList(this.m_aRules);
    }

    public boolean hasStyleRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getStyleRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSStyleRule getStyleRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
                if (n2 == n) {
                    return (CSSStyleRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSStyleRule> getAllStyleRules() {
        ArrayList<CSSStyleRule> arrayList = new ArrayList<CSSStyleRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            arrayList.add((CSSStyleRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasPageRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getPageRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSPageRule getPageRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
                if (n2 == n) {
                    return (CSSPageRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPageRule> getAllPageRules() {
        ArrayList<CSSPageRule> arrayList = new ArrayList<CSSPageRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            arrayList.add((CSSPageRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasMediaRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getMediaRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSMediaRule getMediaRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
                if (n2 == n) {
                    return (CSSMediaRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaRule> getAllMediaRules() {
        ArrayList<CSSMediaRule> arrayList = new ArrayList<CSSMediaRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            arrayList.add((CSSMediaRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasFontFaceRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
                if (n2 == n) {
                    return (CSSFontFaceRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSFontFaceRule> getAllFontFaceRules() {
        ArrayList<CSSFontFaceRule> arrayList = new ArrayList<CSSFontFaceRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            arrayList.add((CSSFontFaceRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasKeyframesRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
                if (n2 == n) {
                    return (CSSKeyframesRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesRule> getAllKeyframesRules() {
        ArrayList<CSSKeyframesRule> arrayList = new ArrayList<CSSKeyframesRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            arrayList.add((CSSKeyframesRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasViewportRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getViewportRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSViewportRule getViewportRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
                if (n2 == n) {
                    return (CSSViewportRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSViewportRule> getAllViewportRules() {
        ArrayList<CSSViewportRule> arrayList = new ArrayList<CSSViewportRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            arrayList.add((CSSViewportRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasSupportsRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSSupportsRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSSupportsRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSSupportsRule)) continue;
                if (n2 == n) {
                    return (CSSSupportsRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSupportsRule> getAllSupportsRules() {
        ArrayList<CSSSupportsRule> arrayList = new ArrayList<CSSSupportsRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSSupportsRule)) continue;
            arrayList.add((CSSSupportsRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasUnknownRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSUnknownRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSUnknownRule)) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int n) {
        if (n >= 0) {
            int n2 = 0;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                if (!(iCSSTopLevelRule instanceof CSSUnknownRule)) continue;
                if (n2 == n) {
                    return (CSSUnknownRule)iCSSTopLevelRule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSUnknownRule> getAllUnknownRules() {
        ArrayList<CSSUnknownRule> arrayList = new ArrayList<CSSUnknownRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSUnknownRule)) continue;
            arrayList.add((CSSUnknownRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CascadingStyleSheet cascadingStyleSheet = (CascadingStyleSheet)object;
        return this.m_aImportRules.equals(cascadingStyleSheet.m_aImportRules) && this.m_aNamespaceRules.equals(cascadingStyleSheet.m_aNamespaceRules) && this.m_aRules.equals(cascadingStyleSheet.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

