/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.helger.css.property.CSSPropertyFree;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.writer.CSSWriterSettings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CSSShortHandDescriptor {
    private final ECSSProperty m_eProperty;
    private final List<CSSPropertyWithDefaultValue> m_aSubProperties;
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public CSSShortHandDescriptor(@Nonnull ECSSProperty eCSSProperty, CSSPropertyWithDefaultValue ... cSSPropertyWithDefaultValueArray) {
        ValueEnforcer.notNull((Object)eCSSProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])cSSPropertyWithDefaultValueArray, (String)"SubProperties");
        this.m_eProperty = eCSSProperty;
        this.m_aSubProperties = ContainerHelper.newList((Object[])cSSPropertyWithDefaultValueArray);
        int n = 0;
        int n2 = 0;
        int n3 = cSSPropertyWithDefaultValueArray.length;
        for (int i = 0; i < n3; ++i) {
            CSSPropertyWithDefaultValue cSSPropertyWithDefaultValue = cSSPropertyWithDefaultValueArray[i];
            ICSSProperty iCSSProperty = cSSPropertyWithDefaultValue.getProperty();
            if (iCSSProperty instanceof CSSPropertyFree && i < n3 - 1) {
                throw new IllegalArgumentException("The SubProperty " + cSSPropertyWithDefaultValue + " may not use an unspecified CSSPropertyFree except for the last element!");
            }
            n += iCSSProperty.getMinimumArgumentCount();
            n2 += iCSSProperty.getMaximumArgumentCount();
        }
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Nonnull
    public ECSSProperty getProperty() {
        return this.m_eProperty;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPropertyWithDefaultValue> getAllSubProperties() {
        return ContainerHelper.newList(this.m_aSubProperties);
    }

    @OverrideOnDemand
    protected void modifyExpressionMembers(@Nonnull List<ICSSExpressionMember> list) {
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getSplitIntoPieces(@Nonnull CSSDeclaration cSSDeclaration) {
        Object object;
        int n;
        ValueEnforcer.notNull((Object)cSSDeclaration, (String)"Declaration");
        if (!cSSDeclaration.getProperty().equals(this.m_eProperty.getName())) {
            throw new IllegalArgumentException("Cannot split a '" + cSSDeclaration.getProperty() + "' as a '" + this.m_eProperty.getName() + "'");
        }
        int n2 = this.m_aSubProperties.size();
        ArrayList<CSSDeclaration> arrayList = new ArrayList<CSSDeclaration>();
        List<ICSSExpressionMember> list = cSSDeclaration.getExpression().getAllMembers();
        this.modifyExpressionMembers(list);
        int n3 = list.size();
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(ECSSVersion.CSS30, false);
        boolean[] blArray = new boolean[n2];
        block0: for (n = 0; n < n3; ++n) {
            object = list.get(n);
            for (int i = 0; i < n2; ++i) {
                CSSPropertyWithDefaultValue cSSPropertyWithDefaultValue;
                ICSSProperty iCSSProperty;
                int n4;
                if (blArray[i] || n + (n4 = (iCSSProperty = (cSSPropertyWithDefaultValue = this.m_aSubProperties.get(i)).getProperty()).getMinimumArgumentCount()) - 1 >= n3) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < n4; ++j) {
                    String string = object.getAsCSSString(cSSWriterSettings, 0);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string);
                }
                if (!iCSSProperty.isValidValue(stringBuilder.toString())) continue;
                CSSExpression cSSExpression = new CSSExpression();
                for (int j = 0; j < n4; ++j) {
                    cSSExpression.addMember(list.get(n + j));
                }
                arrayList.add(new CSSDeclaration(cSSPropertyWithDefaultValue.getProperty().getPropertyName(), cSSExpression));
                n += n4 - 1;
                blArray[i] = true;
                continue block0;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            object = this.m_aSubProperties.get(n);
            CSSExpression cSSExpression = new CSSExpression();
            cSSExpression.addMember(new CSSExpressionMemberTermSimple(((CSSPropertyWithDefaultValue)object).getDefaultValue()));
            arrayList.add(new CSSDeclaration(((CSSPropertyWithDefaultValue)object).getProperty().getPropertyName(), cSSExpression));
        }
        return arrayList;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Enum)this.m_eProperty).append("subProperties", this.m_aSubProperties).toString();
    }
}

