/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSAttributeOperator implements ICSSVersionAware,
ICSSWriteable,
IHasName
{
    EQUALS("=", ECSSVersion.CSS21),
    INCLUDES("~=", ECSSVersion.CSS21),
    DASHMATCH("|=", ECSSVersion.CSS21),
    BEGINMATCH("^=", ECSSVersion.CSS30),
    ENDMATCH("$=", ECSSVersion.CSS30),
    CONTAINSMATCH("*=", ECSSVersion.CSS21);

    private final String m_sName;
    private final ECSSVersion m_eVersion;

    private ECSSAttributeOperator(String string2, ECSSVersion eCSSVersion) {
        this.m_sName = string2;
        this.m_eVersion = eCSSVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.m_sName;
    }

    @Nullable
    public static ECSSAttributeOperator getFromNameOrNull(@Nullable String string) {
        return (ECSSAttributeOperator)EnumHelper.getFromNameOrNull(ECSSAttributeOperator.class, (String)string);
    }
}

