/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaList
implements ICSSMediaList,
ICloneable<CSSMediaList> {
    public static final String DEFAULT_MEDIA_STRING_SEPARATOR = ", ";
    private final Set<ECSSMedium> m_aMedia = new LinkedHashSet<ECSSMedium>();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eCSSMedium) {
        this.addMedium(eCSSMedium);
    }

    public CSSMediaList(ECSSMedium ... eCSSMediumArray) {
        if (eCSSMediumArray != null) {
            for (ECSSMedium eCSSMedium : eCSSMediumArray) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> iterable) {
        if (iterable != null) {
            for (ECSSMedium eCSSMedium : iterable) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nonnull CSSMediaList cSSMediaList) {
        ValueEnforcer.notNull((Object)cSSMediaList, (String)"Other");
        this.m_aMedia.addAll(cSSMediaList.m_aMedia);
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eCSSMedium) {
        ValueEnforcer.notNull((Object)eCSSMedium, (String)"Medium");
        this.m_aMedia.add(eCSSMedium);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eCSSMedium) {
        return EChange.valueOf((boolean)this.m_aMedia.remove(eCSSMedium));
    }

    @Nonnull
    public EChange removeAllMedia() {
        if (this.m_aMedia.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMedia.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnegative
    public int getMediaCount() {
        return this.m_aMedia.size();
    }

    @Override
    public boolean hasAnyMedia() {
        return !this.m_aMedia.isEmpty();
    }

    @Override
    public boolean hasNoMedia() {
        return this.m_aMedia.isEmpty();
    }

    @Override
    public boolean hasNoMediaOrAll() {
        return this.hasNoMedia() || this.containsMedium(ECSSMedium.ALL);
    }

    @Override
    public boolean containsMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.contains(eCSSMedium);
    }

    @Override
    public boolean containsMediumOrAll(@Nullable ECSSMedium eCSSMedium) {
        return this.containsMedium(eCSSMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    @Override
    public boolean isForScreen() {
        return this.hasNoMedia() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<ECSSMedium> getAllMedia() {
        return ContainerHelper.newSortedSet(this.m_aMedia);
    }

    @Override
    @Nonnull
    public String getMediaString() {
        return this.getMediaString(DEFAULT_MEDIA_STRING_SEPARATOR);
    }

    @Override
    @Nonnull
    public String getMediaString(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ECSSMedium eCSSMedium : this.m_aMedia) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(eCSSMedium.getName());
        }
        return stringBuilder.toString();
    }

    @Nonnegative
    public int size() {
        return this.getMediaCount();
    }

    public boolean isEmpty() {
        return this.hasNoMedia();
    }

    @Nonnull
    @ReturnsMutableCopy
    public CSSMediaList getClone() {
        return new CSSMediaList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaList cSSMediaList = (CSSMediaList)object;
        return this.m_aMedia.equals(cSSMediaList.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).toString();
    }
}

