/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberNot
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final List<CSSSelector> m_aNestedSelectors;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberNot(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"NestedSelector");
        this.m_aNestedSelectors = ContainerHelper.newList((Object)cSSSelector);
    }

    public CSSSelectorMemberNot(CSSSelector ... cSSSelectorArray) {
        ValueEnforcer.notNull((Object)cSSSelectorArray, (String)"NestedSelectors");
        this.m_aNestedSelectors = ContainerHelper.newList((Object[])cSSSelectorArray);
    }

    public CSSSelectorMemberNot(@Nonnull List<CSSSelector> list) {
        ValueEnforcer.notNull(list, (String)"NestedSelectors");
        this.m_aNestedSelectors = ContainerHelper.newList(list);
    }

    public boolean hasSelectors() {
        return !this.m_aNestedSelectors.isEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aNestedSelectors.size();
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        this.m_aNestedSelectors.add(cSSSelector);
        return this;
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int n, @Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(n, new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int n, @Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        if (n >= this.getSelectorCount()) {
            this.m_aNestedSelectors.add(cSSSelector);
        } else {
            this.m_aNestedSelectors.add(n, cSSSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector cSSSelector) {
        return EChange.valueOf((boolean)this.m_aNestedSelectors.remove(cSSSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aNestedSelectors.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aNestedSelectors.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllSelectors() {
        if (this.m_aNestedSelectors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aNestedSelectors.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int n) {
        return (CSSSelector)ContainerHelper.getSafe(this.m_aNestedSelectors, (int)n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSelector> getAllSelectors() {
        return ContainerHelper.newList(this.m_aNestedSelectors);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(":not(");
        boolean bl2 = true;
        for (CSSSelector cSSSelector : this.m_aNestedSelectors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(cSSSelector.getAsCSSString(iCSSWriterSettings, 0));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberNot cSSSelectorMemberNot = (CSSSelectorMemberNot)object;
        return this.m_aNestedSelectors.equals(cSSSelectorMemberNot.m_aNestedSelectors);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNestedSelectors).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("nestedSelectors", this.m_aNestedSelectors).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

