/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelector
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final List<ICSSSelectorMember> m_aMembers = new ArrayList<ICSSSelectorMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return !this.m_aMembers.isEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSelector addMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"Member");
        this.m_aMembers.add(iCSSSelectorMember);
        return this;
    }

    @Nonnull
    public CSSSelector addMember(@Nonnegative int n, @Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSSelectorMember);
        } else {
            this.m_aMembers.add(n, iCSSSelectorMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSSelectorMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSSelectorMember getMemberAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return null;
        }
        return this.m_aMembers.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSelectorMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSSelectorMember iCSSSelectorMember : this.m_aMembers) {
            stringBuilder.append(iCSSSelectorMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelector cSSSelector = (CSSSelector)object;
        return this.m_aMembers.equals(cSSSelector.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

