/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnumOrNumbers
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, null, bl, n, n2, stringArray);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, null, bl, n, n2, iterable);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSNumberHelper.isValueWithUnit(string3, this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumbers getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrNumbers(eCSSProperty, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyEnumOrNumbers cSSPropertyEnumOrNumbers = (CSSPropertyEnumOrNumbers)object;
        return this.m_bWithPercentage == cSSPropertyEnumOrNumbers.m_bWithPercentage && this.m_nMinNumbers == cSSPropertyEnumOrNumbers.m_nMinNumbers && this.m_nMaxNumbers == cSSPropertyEnumOrNumbers.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

