/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorSimpleMember
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorSimpleMember(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isElementName() {
        return !this.isHash() && !this.isClass() && !this.isPseudo();
    }

    public boolean isHash() {
        return this.m_sValue.charAt(0) == '#';
    }

    public boolean isClass() {
        return this.m_sValue.charAt(0) == '.';
    }

    public boolean isPseudo() {
        return this.m_sValue.charAt(0) == ':';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sValue;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorSimpleMember cSSSelectorSimpleMember = (CSSSelectorSimpleMember)object;
        return this.m_sValue.equals(cSSSelectorSimpleMember.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

