/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.csscompress;

import com.helger.base.charset.CharsetHelper;
import com.helger.base.io.EAppend;
import com.helger.base.system.ENewLineMode;
import com.helger.base.system.EOperatingSystem;
import com.helger.css.CSSFilenameHelper;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.FileSystemResource;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.Function;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class CSSCompressMojo
extends AbstractMojo {
    private static final String[] EXTENSIONS_CSS_COMPRESSED = new String[]{".min.css", "-min.css", ".minified.css", "-minified.css"};
    private MavenProject project;
    private File sourceDirectory;
    private File targetDirectory;
    private boolean recursive = true;
    private boolean removeUnnecessaryCode = false;
    private boolean quoteURLs = false;
    private boolean writeNamespaceRules = true;
    private boolean writeFontFaceRules = true;
    private boolean writeKeyframesRules = true;
    private boolean writeMediaRules = true;
    private boolean writePageRules = true;
    private boolean writeViewportRules = true;
    private boolean writeSupportsRules = true;
    private boolean writeUnknownRules = true;
    private boolean forceCompress = false;
    private boolean verbose = false;
    private boolean browserCompliantMode = false;
    private boolean keepDeprecatedProperties = false;
    private String sourceEncoding = CSSReaderSettings.DEFAULT_CHARSET.name();
    private String targetFileExtension = ".min.css";
    private String targetEncoding = StandardCharsets.UTF_8.name();
    private ENewLineMode newLineMode = CSSWriterSettings.DEFAULT_NEW_LINE_MODE;

    public void setSourceDirectory(File file) throws IOException {
        this.sourceDirectory = file;
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = new File(this.project.getBasedir(), file.getPath()).getCanonicalFile();
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("CSS source directory '" + String.valueOf(this.sourceDirectory) + "' does not exist!"));
        }
    }

    public void setTargetDirectory(File file) throws IOException {
        this.targetDirectory = file;
        if (!this.targetDirectory.isAbsolute()) {
            this.targetDirectory = new File(this.project.getBasedir(), file.getPath()).getCanonicalFile();
        }
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setRemoveUnnecessaryCode(boolean bl) {
        this.removeUnnecessaryCode = bl;
    }

    public void setQuoteURLs(boolean bl) {
        this.quoteURLs = bl;
    }

    public void setWriteNamespaceRules(boolean bl) {
        this.writeNamespaceRules = bl;
    }

    public void setWriteFontFaceRules(boolean bl) {
        this.writeFontFaceRules = bl;
    }

    public void setWriteKeyframesRules(boolean bl) {
        this.writeKeyframesRules = bl;
    }

    public void setWriteMediaRules(boolean bl) {
        this.writeMediaRules = bl;
    }

    public void setWritePageRules(boolean bl) {
        this.writePageRules = bl;
    }

    public void setWriteViewportRules(boolean bl) {
        this.writeViewportRules = bl;
    }

    public void setWriteSupportsRules(boolean bl) {
        this.writeSupportsRules = bl;
    }

    public void setWriteUnknownRules(boolean bl) {
        this.writeUnknownRules = bl;
    }

    public void setForceCompress(boolean bl) {
        this.forceCompress = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setBrowserCompliantMode(boolean bl) {
        this.browserCompliantMode = bl;
    }

    public void setKeepDeprecatedProperties(boolean bl) {
        this.keepDeprecatedProperties = bl;
    }

    public void setSourceEncoding(String string) {
        CharsetHelper.getCharsetFromName((String)string);
        this.sourceEncoding = string;
    }

    public void setTargetFileExtension(String string) {
        this.targetFileExtension = string;
    }

    public void setTargetEncoding(String string) {
        CharsetHelper.getCharsetFromName((String)string);
        this.targetEncoding = string;
    }

    public void setNewLineMode(String string) {
        if ("win".equalsIgnoreCase(string) || "windows".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.WINDOWS;
        } else if ("linux".equalsIgnoreCase(string) || "unix".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.UNIX;
        } else if ("mac".equalsIgnoreCase(string) || "apple".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.MAC;
        } else if ("system".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.DEFAULT;
        }
    }

    private static boolean _isAlreadyCompressed(String string) {
        for (String string2 : EXTENSIONS_CSS_COMPRESSED) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private String _getSourceRelativePath(@Nonnull File file) {
        return file.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length() + 1);
    }

    private void _compressCSSFile(@Nonnull File file) {
        String string = this._getSourceRelativePath(file);
        boolean bl = this.targetDirectory == null || this.targetDirectory.getAbsolutePath().equals(this.sourceDirectory.getAbsolutePath());
        File file2 = bl ? new File(FilenameHelper.getWithoutExtension((String)file.getAbsolutePath()) + this.targetFileExtension) : new File(this.targetDirectory, FilenameHelper.getWithoutExtension((String)string) + this.targetFileExtension);
        if (file2.lastModified() < file.lastModified() || this.forceCompress) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Start compressing CSS file " + string));
            } else {
                this.getLog().debug((CharSequence)("Start compressing CSS file " + string));
            }
            ICSSParseExceptionCallback iCSSParseExceptionCallback = parseException -> this.getLog().error((CharSequence)("Failed to parse CSS file " + string), parseException);
            Charset charset = CharsetHelper.getCharsetFromName((String)this.sourceEncoding);
            CSSReaderSettings cSSReaderSettings = new CSSReaderSettings().setFallbackCharset(charset).setCustomExceptionHandler(iCSSParseExceptionCallback).setBrowserCompliantMode(this.browserCompliantMode).setKeepDeprecatedProperties(this.keepDeprecatedProperties);
            CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromFile((File)file, (CSSReaderSettings)cSSReaderSettings);
            if (cascadingStyleSheet != null) {
                FileSystemResource fileSystemResource = new FileSystemResource(file2);
                try {
                    CSSWriterSettings cSSWriterSettings = new CSSWriterSettings();
                    cSSWriterSettings.setOptimizedOutput(true);
                    cSSWriterSettings.setRemoveUnnecessaryCode(this.removeUnnecessaryCode);
                    cSSWriterSettings.setNewLineMode(this.newLineMode);
                    cSSWriterSettings.setQuoteURLs(this.quoteURLs);
                    cSSWriterSettings.setWriteNamespaceRules(this.writeNamespaceRules);
                    cSSWriterSettings.setWriteFontFaceRules(this.writeFontFaceRules);
                    cSSWriterSettings.setWriteKeyframesRules(this.writeKeyframesRules);
                    cSSWriterSettings.setWriteMediaRules(this.writeMediaRules);
                    cSSWriterSettings.setWritePageRules(this.writePageRules);
                    cSSWriterSettings.setWriteViewportRules(this.writeViewportRules);
                    cSSWriterSettings.setWriteSupportsRules(this.writeSupportsRules);
                    cSSWriterSettings.setWriteUnknownRules(this.writeUnknownRules);
                    Charset charset2 = CharsetHelper.getCharsetFromName((String)this.targetEncoding);
                    new CSSWriter(cSSWriterSettings).writeCSS(cascadingStyleSheet, fileSystemResource.getWriter(charset2, EAppend.TRUNCATE));
                }
                catch (IOException iOException) {
                    this.getLog().error((CharSequence)("Failed to write compressed CSS file '" + file2.toString() + "' to disk"), (Throwable)iOException);
                }
            }
        } else if (this.verbose) {
            this.getLog().info((CharSequence)("Ignoring already compressed CSS file " + string));
        } else {
            this.getLog().debug((CharSequence)("Ignoring already compressed CSS file " + string));
        }
    }

    private void _scanDirectory(@Nonnull File file) {
        for (File file2 : FileHelper.getDirectoryContent((File)file)) {
            if (file2.isDirectory()) {
                if (!this.recursive) continue;
                this._scanDirectory(file2);
                continue;
            }
            if (!file2.isFile() || !CSSFilenameHelper.isCSSFilename((String)file2.getName()) || CSSCompressMojo._isAlreadyCompressed(file2.getName())) continue;
            this._compressCSSFile(file2);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.verbose) {
            this.getLog().info((CharSequence)("Start compressing CSS files in directory " + this.sourceDirectory.getPath()));
        }
        if (this.targetDirectory != null) {
            Function<File, String> function;
            boolean bl = EOperatingSystem.getCurrentOS().isWindowsBased();
            Function<File, String> function2 = function = bl ? file -> file.getAbsolutePath().toLowerCase(Locale.ROOT) : File::getAbsolutePath;
            if (this.recursive && function.apply(this.targetDirectory).startsWith(function.apply(this.sourceDirectory))) {
                throw new IllegalStateException("Target directory MUST NOT be a child of the source directory in recursive mode");
            }
            if (!this.targetDirectory.exists()) {
                this.getLog().info((CharSequence)("CSS target directory '" + String.valueOf(this.targetDirectory) + "' does not exist and will be created!"));
                FileOperationManager.INSTANCE.createDirRecursive(this.targetDirectory);
            }
        }
        this._scanDirectory(this.sourceDirectory);
    }
}

