/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.csscompress;

import com.helger.commons.charset.CharsetManager;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.system.ENewLineMode;
import com.helger.css.CSSFilenameHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.parser.ParseException;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="set via maven property")
public final class CSSCompressMojo
extends AbstractMojo {
    private static final String[] EXTENSIONS_CSS_COMPRESSED = new String[]{".min.css", "-min.css", ".minified.css", "-minified.css"};
    private MavenProject project;
    private File sourceDirectory;
    private boolean recursive = true;
    private boolean removeUnnecessaryCode = false;
    private boolean quoteURLs = false;
    private boolean writeNamespaceRules = true;
    private boolean writeFontFaceRules = true;
    private boolean writeKeyframesRules = true;
    private boolean writeMediaRules = true;
    private boolean writePageRules = true;
    private boolean writeViewportRules = true;
    private boolean writeSupportsRules = true;
    private boolean writeUnknownRules = true;
    private boolean forceCompress = false;
    private boolean verbose = false;
    private boolean browserCompliantMode = false;
    private String sourceEncoding = "UTF-8";
    private String targetFileExtension = ".min.css";
    private String targetEncoding = "UTF-8";
    private ENewLineMode newLineMode = CSSWriterSettings.DEFAULT_NEW_LINE_MODE;

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
    public void setSourceDirectory(File file) {
        this.sourceDirectory = file;
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("CSS source directory '" + this.sourceDirectory + "' does not exist!"));
        }
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setRemoveUnnecessaryCode(boolean bl) {
        this.removeUnnecessaryCode = bl;
    }

    public void setQuoteURLs(boolean bl) {
        this.quoteURLs = bl;
    }

    public void setWriteNamespaceRules(boolean bl) {
        this.writeNamespaceRules = bl;
    }

    public void setWriteFontFaceRules(boolean bl) {
        this.writeFontFaceRules = bl;
    }

    public void setWriteKeyframesRules(boolean bl) {
        this.writeKeyframesRules = bl;
    }

    public void setWriteMediaRules(boolean bl) {
        this.writeMediaRules = bl;
    }

    public void setWritePageRules(boolean bl) {
        this.writePageRules = bl;
    }

    public void setWriteViewportRules(boolean bl) {
        this.writeViewportRules = bl;
    }

    public void setWriteSupportsRules(boolean bl) {
        this.writeSupportsRules = bl;
    }

    public void setWriteUnknownRules(boolean bl) {
        this.writeUnknownRules = bl;
    }

    public void setForceCompress(boolean bl) {
        this.forceCompress = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setBrowserCompliantMode(boolean bl) {
        this.browserCompliantMode = bl;
    }

    public void setSourceEncoding(String string) {
        CharsetManager.getCharsetFromName((String)string);
        this.sourceEncoding = string;
    }

    public void setTargetFileExtension(String string) {
        this.targetFileExtension = string;
    }

    public void setTargetEncoding(String string) {
        CharsetManager.getCharsetFromName((String)string);
        this.targetEncoding = string;
    }

    public void setNewLineMode(String string) {
        if ("win".equalsIgnoreCase(string) || "windows".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.WINDOWS;
        } else if ("linux".equalsIgnoreCase(string) || "unix".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.UNIX;
        } else if ("mac".equalsIgnoreCase(string) || "apple".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.MAC;
        } else if ("system".equalsIgnoreCase(string)) {
            this.newLineMode = ENewLineMode.DEFAULT;
        }
    }

    private static boolean _isAlreadyCompressed(String string) {
        for (String string2 : EXTENSIONS_CSS_COMPRESSED) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private String _getRelativePath(@Nonnull File file) {
        return file.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length() + 1);
    }

    private void _compressCSSFile(final @Nonnull File file) {
        File file2 = new File(FilenameHelper.getWithoutExtension((String)file.getAbsolutePath()) + this.targetFileExtension);
        if (file2.lastModified() < file.lastModified() || this.forceCompress) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Start compressing CSS file " + this._getRelativePath(file)));
            } else {
                this.getLog().debug((CharSequence)("Start compressing CSS file " + this._getRelativePath(file)));
            }
            ICSSParseExceptionCallback iCSSParseExceptionCallback = new ICSSParseExceptionCallback(){

                public void onException(@Nonnull ParseException parseException) {
                    CSSCompressMojo.this.getLog().error((CharSequence)("Failed to parse CSS file " + CSSCompressMojo.this._getRelativePath(file)), (Throwable)parseException);
                }
            };
            Charset charset = CharsetManager.getCharsetFromName((String)this.sourceEncoding);
            CSSReaderSettings cSSReaderSettings = new CSSReaderSettings().setCSSVersion(ECSSVersion.CSS30).setFallbackCharset(charset).setCustomExceptionHandler(iCSSParseExceptionCallback).setBrowserCompliantMode(this.browserCompliantMode);
            CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromFile((File)file, (CSSReaderSettings)cSSReaderSettings);
            if (cascadingStyleSheet != null) {
                FileSystemResource fileSystemResource = new FileSystemResource(file2);
                try {
                    CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(ECSSVersion.CSS30);
                    cSSWriterSettings.setOptimizedOutput(true);
                    cSSWriterSettings.setRemoveUnnecessaryCode(this.removeUnnecessaryCode);
                    cSSWriterSettings.setNewLineMode(this.newLineMode);
                    cSSWriterSettings.setQuoteURLs(this.quoteURLs);
                    cSSWriterSettings.setWriteNamespaceRules(this.writeNamespaceRules);
                    cSSWriterSettings.setWriteFontFaceRules(this.writeFontFaceRules);
                    cSSWriterSettings.setWriteKeyframesRules(this.writeKeyframesRules);
                    cSSWriterSettings.setWriteMediaRules(this.writeMediaRules);
                    cSSWriterSettings.setWritePageRules(this.writePageRules);
                    cSSWriterSettings.setWriteViewportRules(this.writeViewportRules);
                    cSSWriterSettings.setWriteSupportsRules(this.writeSupportsRules);
                    cSSWriterSettings.setWriteUnknownRules(this.writeUnknownRules);
                    Charset charset2 = CharsetManager.getCharsetFromName((String)this.targetEncoding);
                    new CSSWriter(cSSWriterSettings).writeCSS(cascadingStyleSheet, fileSystemResource.getWriter(charset2, EAppend.TRUNCATE));
                }
                catch (IOException iOException) {
                    this.getLog().error((CharSequence)("Failed to write compressed CSS file '" + file2.toString() + "' to disk"), (Throwable)iOException);
                }
            }
        } else if (this.verbose) {
            this.getLog().info((CharSequence)("Ignoring already compressed CSS file " + this._getRelativePath(file)));
        } else {
            this.getLog().debug((CharSequence)("Ignoring already compressed CSS file " + this._getRelativePath(file)));
        }
    }

    private void _scanDirectory(@Nonnull File file) {
        for (File file2 : FileHelper.getDirectoryContent((File)file)) {
            if (file2.isDirectory()) {
                if (!this.recursive) continue;
                this._scanDirectory(file2);
                continue;
            }
            if (!file2.isFile() || !CSSFilenameHelper.isCSSFilename((String)file2.getName()) || CSSCompressMojo._isAlreadyCompressed(file2.getName())) continue;
            this._compressCSSFile(file2);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.verbose) {
            this.getLog().info((CharSequence)("Start compressing CSS files in directory " + this.sourceDirectory.getPath()));
        }
        this._scanDirectory(this.sourceDirectory);
    }
}

