/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillCloseWhenClosed;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.iterator.CombinedIterator;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.xml.EXMLVersion;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeXMLStreamWriter
implements XMLStreamWriter,
AutoCloseable,
IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeXMLStreamWriter.class);
    private static final AtomicBoolean DEFAULT_DEBUG_MODE = new AtomicBoolean(false);
    private final XMLEmitter m_aEmitter;
    private final boolean m_bIndent;
    private final String m_sIndent;
    private final MultiNamespaceContext m_aNamespaceContext = new MultiNamespaceContext();
    private final NonBlockingStack<ElementState> m_aElementStateStack = new NonBlockingStack<ElementState>(){

        public ElementState push(ElementState elementState) {
            int n = this.size();
            ElementState elementState2 = (ElementState)super.push((Object)elementState);
            SafeXMLStreamWriter.this.debug(() -> "Pushed[" + n + "->" + (n + 1) + "] " + String.valueOf(elementState));
            return elementState2;
        }

        public ElementState pop() {
            int n = this.size();
            ElementState elementState = (ElementState)super.pop();
            SafeXMLStreamWriter.this.debug(() -> "Popped[" + n + "->" + (n - 1) + "] " + String.valueOf(elementState));
            return elementState;
        }
    };
    private boolean m_bInElementStart = false;
    private final ConditionalLogger m_aCondLog = new ConditionalLogger(LOGGER, DEFAULT_DEBUG_MODE.get());

    public static boolean isDefaultDebugMode() {
        return DEFAULT_DEBUG_MODE.get();
    }

    public static void setDefaultDebugMode(boolean bl) {
        DEFAULT_DEBUG_MODE.set(bl);
    }

    public SafeXMLStreamWriter(@NonNull XMLEmitter xMLEmitter) {
        ValueEnforcer.notNull((Object)xMLEmitter, (String)"Emitter");
        this.m_aEmitter = xMLEmitter;
        this.m_bIndent = xMLEmitter.getXMLWriterSettings().getIndent().isIndent();
        this.m_sIndent = xMLEmitter.getXMLWriterSettings().getIndentationString();
    }

    public final boolean isDebugMode() {
        return this.m_aCondLog.isEnabled();
    }

    public final @NonNull SafeXMLStreamWriter setDebugMode(boolean bl) {
        this.m_aCondLog.setEnabled(bl);
        return this;
    }

    private void _indent() {
        int n;
        if (this.m_bIndent && (n = this.m_aElementStateStack.size()) > 0) {
            ElementState elementState = (ElementState)this.m_aElementStateStack.peek();
            if (elementState.m_nTextBasedContentCount == 0) {
                this.debug(() -> "indent[" + n + "]");
                this.m_aEmitter.onContentElementWhitespace(StringHelper.getRepeated((String)this.m_sIndent, (int)n));
            }
        }
    }

    private void _newLineBeforeStartElement() {
        int n = this.m_aElementStateStack.size();
        if (n > 0) {
            ElementState elementState = (ElementState)this.m_aElementStateStack.peek();
            if (elementState.m_nTextBasedContentCount == 0 && !elementState.m_bOnAfterEndNewLine) {
                this.debug(() -> "newLineBeforeStartElement");
                this.m_aEmitter.newLine();
            }
        }
    }

    private boolean _newLineAfterEndElement() {
        int n = this.m_aElementStateStack.size();
        if (n > 0) {
            ElementState elementState = (ElementState)this.m_aElementStateStack.peek();
            if (elementState.m_nTextBasedContentCount == 0) {
                this.debug(() -> "newLineAfterEndElement");
                this.m_aEmitter.newLine();
                elementState.m_bOnAfterEndNewLine = true;
                return true;
            }
        }
        return false;
    }

    private void _setTextBasedContent() {
        ElementState elementState = (ElementState)this.m_aElementStateStack.peek();
        ++elementState.m_nTextBasedContentCount;
    }

    private void _setElementBasedContent() {
        if (this.m_aElementStateStack.isNotEmpty()) {
            ElementState elementState = (ElementState)this.m_aElementStateStack.peek();
            ++elementState.m_nElementBasedContentCount;
        }
    }

    @OverrideOnDemand
    protected void debug(@NonNull Supplier<String> supplier) {
        this.m_aCondLog.info(supplier);
    }

    private @NonNull IXMLWriterSettings _getSettings() {
        return this.m_aEmitter.getXMLWriterSettings();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(this._getSettings().getCharset(), this._getSettings().getXMLVersion());
    }

    @Override
    public void writeStartDocument(@Nullable String string) throws XMLStreamException {
        this.writeStartDocument(this._getSettings().getCharset(), EXMLVersion.getFromVersionOrNull(string));
    }

    @Override
    public void writeStartDocument(@NonNull String string, @Nullable String string2) throws XMLStreamException {
        this.writeStartDocument(CharsetHelper.getCharsetFromName((String)string), EXMLVersion.getFromVersionOrNull(string2));
    }

    public void writeStartDocument(@NonNull Charset charset, @NonNull EXMLVersion eXMLVersion) {
        this.debug(() -> "writeStartDocument (" + String.valueOf(charset) + ", " + String.valueOf((Object)eXMLVersion) + ")");
        if (this.m_aEmitter.getXMLWriterSettings().getSerializeXMLDeclaration().isEmit()) {
            this.m_aEmitter.onXMLDeclaration(eXMLVersion, charset.name(), ETriState.UNDEFINED, true);
        }
    }

    @Override
    public void writeDTD(@NonNull String string) throws XMLStreamException {
        this.debug(() -> "writeDTD (" + string + ")");
        this.m_aEmitter.onDTD(string);
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElement(null, string);
    }

    @Override
    public void writeStartElement(@Nullable String string, String string2) throws XMLStreamException {
        this.writeStartElement(null, string2, string);
    }

    @Override
    public void writeStartElement(@Nullable String string, String string2, @Nullable String string3) throws XMLStreamException {
        this.debug(() -> "writeStartElement (" + string + ", " + string2 + ", " + string3 + ")");
        this._elementStartClose();
        this._setElementBasedContent();
        this._newLineBeforeStartElement();
        this._indent();
        this.m_aEmitter.elementStartOpen(string, string2);
        this.m_aElementStateStack.push((Object)new ElementState(string, string2, EXMLSerializeBracketMode.OPEN_CLOSE, this.m_aNamespaceContext.m_aInternalContext.getClone()));
        this.m_bInElementStart = true;
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeEmptyElement(null, string);
    }

    @Override
    public void writeEmptyElement(@Nullable String string, String string2) throws XMLStreamException {
        this.writeStartElement(null, string2, string);
    }

    @Override
    public void writeEmptyElement(@Nullable String string, String string2, @Nullable String string3) throws XMLStreamException {
        this.debug(() -> "writeEmptyElement (" + string + ", " + string2 + ", " + string3 + ")");
        this._elementStartClose();
        this._setElementBasedContent();
        this._newLineBeforeStartElement();
        this._indent();
        this.m_aEmitter.elementStartOpen(string, string2);
        this.m_aElementStateStack.push((Object)new ElementState(string, string2, EXMLSerializeBracketMode.SELF_CLOSED, this.m_aNamespaceContext.m_aInternalContext.getClone()));
        this.m_bInElementStart = true;
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.writeAttribute(null, string, string2);
    }

    @Override
    public void writeAttribute(@Nullable String string, String string2, String string3) throws XMLStreamException {
        this.writeAttribute(null, string, string2, string3);
    }

    @Override
    public void writeAttribute(@Nullable String string, @Nullable String string2, String string3, String string4) throws XMLStreamException {
        this.debug(() -> "writeAttribute (" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        if (!this.m_bInElementStart) {
            throw new IllegalStateException("No element open");
        }
        this.m_aEmitter.elementAttr(string, string3, string4);
    }

    @Override
    public void writeNamespace(@Nullable String string, @NonNull String string2) throws XMLStreamException {
        boolean bl;
        this.debug(() -> "writeNamespace (" + string + ", " + string2 + ")");
        if (!this.m_bInElementStart) {
            throw new IllegalStateException("No element open");
        }
        boolean bl2 = bl = string == null || string.equals("") || string.equals("xmlns");
        if (bl) {
            this.m_aNamespaceContext.m_aInternalContext.setDefaultNamespaceURI(string2);
        } else {
            this.m_aNamespaceContext.m_aInternalContext.setMapping(string, string2);
        }
        if (bl) {
            this.writeAttribute(null, null, "xmlns", string2);
        } else {
            this.writeAttribute("xmlns", null, string, string2);
        }
    }

    @Override
    public void writeDefaultNamespace(@NonNull String string) throws XMLStreamException {
        this.writeNamespace(null, string);
    }

    private void _elementStartClose() {
        if (this.m_bInElementStart) {
            this.m_aEmitter.elementStartClose(((ElementState)this.m_aElementStateStack.peek()).m_eBracketMode);
            this.m_bInElementStart = false;
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        ElementState elementState = (ElementState)this.m_aElementStateStack.pop();
        this.debug(() -> "writeEndElement (" + elementState.m_sPrefix + ", " + elementState.m_sLocalName + ")");
        boolean bl = true;
        if (this.m_bInElementStart) {
            EXMLSerializeBracketMode eXMLSerializeBracketMode;
            if (elementState.getContentCount() == 0 && elementState.m_eBracketMode == EXMLSerializeBracketMode.OPEN_CLOSE) {
                eXMLSerializeBracketMode = EXMLSerializeBracketMode.SELF_CLOSED;
                bl = false;
            } else {
                eXMLSerializeBracketMode = elementState.m_eBracketMode;
            }
            this.m_aEmitter.elementStartClose(eXMLSerializeBracketMode);
            this.m_bInElementStart = false;
        }
        if (bl) {
            if (elementState.m_nTextBasedContentCount == 0) {
                this._indent();
            }
            this.m_aEmitter.onElementEnd(elementState.m_sPrefix, elementState.m_sLocalName, elementState.m_eBracketMode);
        }
        this.m_aNamespaceContext.m_aInternalContext = elementState.m_aNamespaceContext;
        this._newLineAfterEndElement();
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.debug(() -> "writeComment (" + string + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onComment(string);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.debug(() -> "writeCData (" + string + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onCDATA(string);
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.debug(() -> "writeEntityRef (" + string + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onEntityReference(string);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.debug(() -> "writeCharacters (" + string + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onText(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.debug(() -> "writeCharacters (" + String.valueOf(cArray, n, n2) + ", " + n + ", " + n2 + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onText(cArray, n, n2);
    }

    @Override
    public void writeProcessingInstruction(@NonNull String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, null);
    }

    @Override
    public void writeProcessingInstruction(@NonNull String string, @Nullable String string2) throws XMLStreamException {
        this.debug(() -> "writeProcessingInstruction (" + string + ", " + string2 + ")");
        this._elementStartClose();
        this._setTextBasedContent();
        this.m_aEmitter.onProcessingInstruction(string, string2);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.debug(() -> "writeEndDocument ()");
        this._elementStartClose();
        if (this.m_aElementStateStack.isNotEmpty()) {
            throw new IllegalStateException("Internal inconsistency - element stack is not empty: " + String.valueOf(this.m_aElementStateStack));
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        this.debug(() -> "flush ()");
        StreamHelper.flush((Flushable)this.m_aEmitter);
    }

    @Override
    public void close() throws XMLStreamException {
        this.debug(() -> "close ()");
        StreamHelper.close((AutoCloseable)this.m_aEmitter);
    }

    @Override
    public String getPrefix(@NonNull String string) throws XMLStreamException {
        this.debug(() -> "getPrefix (" + string + ")");
        return this.m_aNamespaceContext.getPrefix(string);
    }

    @Override
    public void setPrefix(@NonNull String string, @NonNull String string2) throws XMLStreamException {
        this.debug(() -> "setPrefix (" + string + ", " + string2 + ")");
        this.m_aNamespaceContext.m_aInternalContext.addMapping(string, string2);
    }

    @Override
    public void setDefaultNamespace(@NonNull String string) throws XMLStreamException {
        this.debug(() -> "setDefaultNamespace (" + string + ")");
        this.m_aNamespaceContext.m_aInternalContext.addDefaultNamespaceURI(string);
    }

    @Override
    public void setNamespaceContext(@Nullable NamespaceContext namespaceContext) throws XMLStreamException {
        this.debug(() -> "setNamespaceContext (" + String.valueOf(namespaceContext) + ")");
        this.m_aNamespaceContext.m_aUserContext = namespaceContext;
    }

    @Override
    public @NonNull NamespaceContext getNamespaceContext() {
        this.debug(() -> "getNamespaceContext ()");
        return this.m_aNamespaceContext;
    }

    @Override
    public @Nullable Object getProperty(String string) {
        this.debug(() -> "getProperty (" + string + ") - UNSUPPORTED");
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Emitter", (Object)this.m_aEmitter).append("NamespaceContext", (Object)this.m_aNamespaceContext).append("ElementStateStack", this.m_aElementStateStack).append("InElementStart", this.m_bInElementStart).append("ConditionalLogger", (Object)this.m_aCondLog).getToString();
    }

    public static @NonNull SafeXMLStreamWriter create(@WillCloseWhenClosed @NonNull Writer writer, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        return new SafeXMLStreamWriter(new XMLEmitter(writer, iXMLWriterSettings));
    }

    public static @NonNull SafeXMLStreamWriter create(@WillCloseWhenClosed @NonNull OutputStream outputStream, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        return SafeXMLStreamWriter.create(new OutputStreamWriter(outputStream, iXMLWriterSettings.getCharset()), iXMLWriterSettings);
    }

    private static final class MultiNamespaceContext
    implements NamespaceContext {
        private MapBasedNamespaceContext m_aInternalContext = new MapBasedNamespaceContext();
        private NamespaceContext m_aUserContext;

        @Override
        public @NonNull String getNamespaceURI(@NonNull String string) {
            String string2 = this.m_aInternalContext.getNamespaceURI(string);
            if ("".equals(string2) && this.m_aUserContext != null) {
                string2 = this.m_aUserContext.getNamespaceURI(string);
            }
            return string2;
        }

        @Override
        public @Nullable String getPrefix(@NonNull String string) {
            String string2 = this.m_aInternalContext.getPrefix(string);
            if (string2 == null && this.m_aUserContext != null) {
                string2 = this.m_aUserContext.getPrefix(string);
            }
            return string2;
        }

        @Override
        public @NonNull Iterator<String> getPrefixes(@NonNull String string) {
            Iterator<String> iterator = this.m_aInternalContext.getPrefixes(string);
            if (this.m_aUserContext == null) {
                return iterator;
            }
            Iterator<String> iterator2 = this.m_aUserContext.getPrefixes(string);
            return new CombinedIterator(iterator, iterator2);
        }

        public String toString() {
            return new ToStringGenerator(null).append("InternalContext", (Object)this.m_aInternalContext).append("UserContext", (Object)this.m_aUserContext).getToString();
        }
    }

    private static final class ElementState {
        private final String m_sPrefix;
        private final String m_sLocalName;
        private final EXMLSerializeBracketMode m_eBracketMode;
        private final MapBasedNamespaceContext m_aNamespaceContext;
        private int m_nTextBasedContentCount = 0;
        private int m_nElementBasedContentCount = 0;
        private boolean m_bOnAfterEndNewLine = false;

        public ElementState(@Nullable String string, @NonNull String string2, @NonNull EXMLSerializeBracketMode eXMLSerializeBracketMode, @NonNull MapBasedNamespaceContext mapBasedNamespaceContext) {
            this.m_sPrefix = string;
            this.m_sLocalName = string2;
            this.m_eBracketMode = eXMLSerializeBracketMode;
            this.m_aNamespaceContext = mapBasedNamespaceContext;
        }

        @Nonnegative
        public int getContentCount() {
            return this.m_nTextBasedContentCount + this.m_nElementBasedContentCount;
        }

        public String toString() {
            return new ToStringGenerator(null).append("Prefix", (Object)this.m_sPrefix).append("LocalName", (Object)this.m_sLocalName).append("BracketMode", (Enum)this.m_eBracketMode).append("NsCtx", (Object)this.m_aNamespaceContext.getPrefixToNamespaceURIMap().keySet()).append("TBC", this.m_nTextBasedContentCount).append("EBC", this.m_nElementBasedContentCount).append("OnAfterEndNL", this.m_bOnAfterEndNewLine).getToString();
        }
    }
}

