/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.base.string.StringParser;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.awt.Color;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ColorMicroTypeConverter
implements IMicroTypeConverter<Color> {
    private static final String ATTR_RED = "red";
    private static final String ATTR_GREEN = "green";
    private static final String ATTR_BLUE = "blue";
    private static final String ATTR_ALPHA = "alpha";

    @Override
    public @NonNull IMicroElement convertToMicroElement(@NonNull Color color, @Nullable String string, @NonNull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_RED, color.getRed());
        microElement.setAttribute(ATTR_GREEN, color.getGreen());
        microElement.setAttribute(ATTR_BLUE, color.getBlue());
        microElement.setAttribute(ATTR_ALPHA, color.getAlpha());
        return microElement;
    }

    @Override
    public @NonNull Color convertToNative(@NonNull IMicroElement iMicroElement) {
        int n = StringParser.parseInt((String)iMicroElement.getAttributeValue(ATTR_RED), (int)0);
        int n2 = StringParser.parseInt((String)iMicroElement.getAttributeValue(ATTR_GREEN), (int)0);
        int n3 = StringParser.parseInt((String)iMicroElement.getAttributeValue(ATTR_BLUE), (int)0);
        int n4 = StringParser.parseInt((String)iMicroElement.getAttributeValue(ATTR_ALPHA), (int)255);
        return new Color(n, n2, n3, n4);
    }
}

