/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.ls;

import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.ls.LSInput;

public class ResourceLSInput
implements LSInput {
    private final IHasInputStream m_aISP;
    private Charset m_aEncoding;
    private String m_sPublicId;
    private String m_sSystemId;
    private boolean m_bCertifiedText;
    private String m_sBaseURI;
    private String m_sStringData;

    public ResourceLSInput(@NonNull IReadableResource iReadableResource) {
        this((IHasInputStream)iReadableResource, iReadableResource.getResourceID());
    }

    public ResourceLSInput(@NonNull IHasInputStream iHasInputStream, @Nullable String string) {
        this.m_aISP = (IHasInputStream)ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        this.m_sSystemId = string;
    }

    @Override
    public @Nullable String getBaseURI() {
        return this.m_sBaseURI;
    }

    @Override
    public void setBaseURI(@Nullable String string) {
        this.m_sBaseURI = string;
    }

    public @NonNull IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    @Override
    public @NonNull InputStream getByteStream() {
        return this.m_aISP.getInputStream();
    }

    @Override
    public void setByteStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCertifiedText() {
        return this.m_bCertifiedText;
    }

    @Override
    public void setCertifiedText(boolean bl) {
        this.m_bCertifiedText = bl;
    }

    @Override
    public @Nullable Reader getCharacterStream() {
        return null;
    }

    @Override
    public void setCharacterStream(Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable String getEncoding() {
        return this.m_aEncoding != null ? this.m_aEncoding.name() : null;
    }

    @Override
    public void setEncoding(@Nullable String string) {
        this.m_aEncoding = string == null ? null : CharsetHelper.getCharsetFromName((String)string);
    }

    @Override
    public @Nullable String getPublicId() {
        return this.m_sPublicId;
    }

    @Override
    public void setPublicId(@Nullable String string) {
        this.m_sPublicId = string;
    }

    @Override
    public @Nullable String getStringData() {
        return this.m_sStringData;
    }

    @Override
    public void setStringData(@Nullable String string) {
        this.m_sStringData = string;
    }

    @Override
    public @Nullable String getSystemId() {
        return this.m_sSystemId;
    }

    @Override
    public void setSystemId(@Nullable String string) {
        this.m_sSystemId = string;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ISP", (Object)this.m_aISP).appendIfNotNull("encoding", (Object)this.m_aEncoding).appendIfNotNull("publicId", (Object)this.m_sPublicId).appendIfNotNull("systemId", (Object)this.m_sSystemId).append("certifiedText", this.m_bCertifiedText).appendIfNotNull("baseURI", (Object)this.m_sBaseURI).appendIfNotNull("stringData", (Object)this.m_sStringData).getToString();
    }
}

