/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLVersion;
import com.helger.xml.serialize.read.DOMReaderDefaultSettings;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.validation.Schema;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;

public final class XMLFactory {
    public static final boolean DEFAULT_DOM_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_DOM_VALIDATING = false;
    public static final boolean DEFAULT_DOM_IGNORING_ELEMENT_CONTENT_WHITESPACE = false;
    public static final boolean DEFAULT_DOM_EXPAND_ENTITY_REFERENCES = true;
    public static final boolean DEFAULT_DOM_IGNORING_COMMENTS = true;
    public static final boolean DEFAULT_DOM_COALESCING = true;
    public static final boolean DEFAULT_DOM_XINCLUDE_AWARE = false;
    public static final boolean DEFAULT_SAX_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_SAX_VALIDATING = false;
    public static final boolean DEFAULT_SAX_XINCLUDE_AWARE = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLFactory.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static DocumentBuilderFactory s_aDefaultDocBuilderFactory;
    @GuardedBy(value="RW_LOCK")
    private static DocumentBuilder s_aDefaultDocBuilder;
    private static final XMLFactory INSTANCE;

    public static void reinitialize() {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
            s_aDefaultDocBuilder = null;
        });
    }

    private XMLFactory() {
    }

    public static void setFeature(@NonNull DocumentBuilderFactory documentBuilderFactory, @NonNull EXMLParserFeature eXMLParserFeature, boolean bl) {
        try {
            documentBuilderFactory.setFeature(eXMLParserFeature.getName(), bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn("Failed to set feature " + String.valueOf((Object)eXMLParserFeature) + " to " + bl + " on XML DocumentBuilderFactory: " + parserConfigurationException.getMessage());
        }
    }

    public static void defaultCustomizeDocumentBuilderFactory(@NonNull DocumentBuilderFactory documentBuilderFactory) {
        XMLFactory.setFeature(documentBuilderFactory, EXMLParserFeature.SECURE_PROCESSING, true);
        XMLFactory.setFeature(documentBuilderFactory, EXMLParserFeature.DISALLOW_DOCTYPE_DECL, true);
        XMLFactory.setFeature(documentBuilderFactory, EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false);
        XMLFactory.setFeature(documentBuilderFactory, EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, false);
        XMLFactory.setFeature(documentBuilderFactory, EXMLParserFeature.LOAD_EXTERNAL_DTD, false);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            documentBuilderFactory.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static @NonNull DocumentBuilderFactory createDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XMLFactory.defaultCustomizeDocumentBuilderFactory(documentBuilderFactory);
        return documentBuilderFactory;
    }

    public static @NonNull DocumentBuilderFactory createDocumentBuilderFactory(@NonNull Schema schema) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        DocumentBuilderFactory documentBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
        documentBuilderFactory.setSchema(schema);
        return documentBuilderFactory;
    }

    public static @NonNull DocumentBuilderFactory getDocumentBuilderFactory() {
        return (DocumentBuilderFactory)RW_LOCK.readLockedGet(() -> s_aDefaultDocBuilderFactory);
    }

    public static @NonNull DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = (DocumentBuilder)RW_LOCK.readLockedGet(() -> s_aDefaultDocBuilder);
        if (documentBuilder != null) {
            return documentBuilder;
        }
        return (DocumentBuilder)RW_LOCK.writeLockedGet(() -> {
            DocumentBuilder documentBuilder = s_aDefaultDocBuilder;
            if (documentBuilder == null) {
                documentBuilder = s_aDefaultDocBuilder = XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
            }
            return documentBuilder;
        });
    }

    public static @NonNull DOMImplementation getDOMImplementation() {
        return XMLFactory.getDocumentBuilder().getDOMImplementation();
    }

    public static @NonNull DocumentBuilder createDocumentBuilder() {
        return XMLFactory.createDocumentBuilder(XMLFactory.getDocumentBuilderFactory());
    }

    public static @NonNull DocumentBuilder createDocumentBuilder(@NonNull Schema schema) {
        return XMLFactory.createDocumentBuilder(XMLFactory.createDocumentBuilderFactory(schema));
    }

    public static @NonNull DocumentBuilder createDocumentBuilder(@NonNull DocumentBuilderFactory documentBuilderFactory) {
        ValueEnforcer.notNull((Object)documentBuilderFactory, (String)"DocBuilderFactory");
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(DOMReaderDefaultSettings.getErrorHandler());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to create document builder", (Throwable)parserConfigurationException);
        }
    }

    public static @NonNull Document newDocument() {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), null);
    }

    public static @NonNull Document newDocument(@NonNull DocumentBuilder documentBuilder) {
        return XMLFactory.newDocument(documentBuilder, null);
    }

    public static @NonNull Document newDocument(@Nullable EXMLVersion eXMLVersion) {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), eXMLVersion);
    }

    public static @NonNull Document newDocument(@NonNull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion) {
        ValueEnforcer.notNull((Object)documentBuilder, (String)"DocBuilder");
        Document document = documentBuilder.newDocument();
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }

    public static @NonNull Document newDocument(@NonNull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(null, string, string2, string3);
    }

    public static @NonNull Document newDocument(@Nullable EXMLVersion eXMLVersion, @NonNull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), eXMLVersion, string, string2, string3);
    }

    public static @NonNull Document newDocument(@NonNull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion, @NonNull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull((Object)documentBuilder, (String)"DocBuilder");
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
        Document document = dOMImplementation.createDocument(string3, string, documentType);
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }

    public static void setFeature(@NonNull SAXParserFactory sAXParserFactory, @NonNull EXMLParserFeature eXMLParserFeature, boolean bl) {
        try {
            sAXParserFactory.setFeature(eXMLParserFeature.getName(), bl);
        }
        catch (ParserConfigurationException | SAXException exception) {
            LOGGER.warn("Failed to set feature " + String.valueOf((Object)eXMLParserFeature) + " to " + bl + " on XML SAXParserFactory: " + exception.getMessage());
        }
    }

    public static void defaultCustomizeSAXParserFactory(@NonNull SAXParserFactory sAXParserFactory) {
        XMLFactory.setFeature(sAXParserFactory, EXMLParserFeature.SECURE_PROCESSING, true);
        XMLFactory.setFeature(sAXParserFactory, EXMLParserFeature.DISALLOW_DOCTYPE_DECL, true);
        XMLFactory.setFeature(sAXParserFactory, EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false);
        XMLFactory.setFeature(sAXParserFactory, EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, false);
        XMLFactory.setFeature(sAXParserFactory, EXMLParserFeature.LOAD_EXTERNAL_DTD, false);
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setXIncludeAware(false);
    }

    public static @NonNull SAXParserFactory createDefaultSAXParserFactory() {
        SAXParserFactory sAXParserFactory;
        try {
            sAXParserFactory = SAXParserFactory.newDefaultInstance();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            sAXParserFactory = SAXParserFactory.newInstance();
        }
        XMLFactory.defaultCustomizeSAXParserFactory(sAXParserFactory);
        return sAXParserFactory;
    }

    public static void setFeature(@NonNull TransformerFactory transformerFactory, @NonNull EXMLParserFeature eXMLParserFeature, boolean bl, boolean bl2) {
        block2: {
            try {
                transformerFactory.setFeature(eXMLParserFeature.getName(), bl);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if (!bl2) break block2;
                LOGGER.warn("Failed to set feature " + String.valueOf((Object)eXMLParserFeature) + " to " + bl + " on XML TransformerFactory: " + transformerConfigurationException.getMessage());
            }
        }
    }

    public static void defaultCustomizeTransformerFactory(@NonNull TransformerFactory transformerFactory) {
        XMLFactory.setFeature(transformerFactory, EXMLParserFeature.DISALLOW_DOCTYPE_DECL, true, false);
        XMLFactory.setFeature(transformerFactory, EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false, false);
        XMLFactory.setFeature(transformerFactory, EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, false, false);
        XMLFactory.setFeature(transformerFactory, EXMLParserFeature.LOAD_EXTERNAL_DTD, false, false);
    }

    public static @NonNull TransformerFactory createDefaultTransformerFactory() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            XMLFactory.defaultCustomizeTransformerFactory(transformerFactory);
            return transformerFactory;
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new InitializationException("Failed to create XML TransformerFactory", (Throwable)transformerFactoryConfigurationError);
        }
    }

    static {
        XMLFactory.reinitialize();
        INSTANCE = new XMLFactory();
    }
}

