/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDataAware;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class MicroCDATA
extends AbstractMicroNode
implements IMicroCDATA {
    private final MicroDataAware m_aData;

    public MicroCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData = new MicroDataAware(cArray, n, n2);
    }

    public MicroCDATA(@Nullable CharSequence charSequence) {
        this.m_aData = new MicroDataAware(charSequence);
    }

    private MicroCDATA(@Nonnull MicroDataAware microDataAware) {
        this.m_aData = microDataAware.getClone();
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.CDATA;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#cdata-section";
    }

    @Override
    @Nonnull
    public String getNodeValue() {
        return this.getData().toString();
    }

    @Override
    @Nonnull
    public CharSequence getData() {
        return this.m_aData.getData();
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aData.appendData(charSequence);
    }

    @Override
    public void appendData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.appendData(cArray, n, n2);
    }

    @Override
    public void appendData(char c) {
        this.m_aData.appendData(c);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aData.prependData(charSequence);
    }

    @Override
    public void prependData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.prependData(cArray, n, n2);
    }

    @Override
    public void prependData(char c) {
        this.m_aData.prependData(c);
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aData.setData(charSequence);
    }

    @Override
    @Nonnull
    public IMicroCDATA getClone() {
        return new MicroCDATA(this.m_aData);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroCDATA microCDATA = (MicroCDATA)iMicroNode;
        return this.m_aData.equals(microCDATA.m_aData);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("text", (Object)this.getData()).getToString();
    }
}

