/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.xml.transform.AbstractTransformErrorListener;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingTransformErrorListener
extends AbstractTransformErrorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTransformErrorListener.class);
    private final Locale m_aDisplayLocale;

    public LoggingTransformErrorListener(@Nonnull Locale locale) {
        this.m_aDisplayLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
    }

    @Nonnull
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Override
    protected void internalLog(@Nonnull IError iError) {
        IErrorLevel iErrorLevel = iError.getErrorLevel();
        String string = iError.getAsString(this.m_aDisplayLocale);
        LogHelper.log((Logger)LOGGER, (IErrorLevel)iErrorLevel, (String)string);
    }
}

