/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class CachingTransformStreamSource
extends StreamSource {
    public CachingTransformStreamSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream) {
        this(iHasInputStream, null);
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this(iHasInputStream.getInputStream(), string);
    }

    public CachingTransformStreamSource(@Nullable @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingTransformStreamSource(@Nullable @WillClose InputStream inputStream, @Nullable String string) {
        super((InputStream)(inputStream == null ? null : new NonBlockingByteArrayInputStream(StreamHelper.getAllBytes((InputStream)inputStream))), string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SystemID", (Object)this.getSystemId()).getToString();
    }
}

