/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.resourcebundle;

import com.helger.annotation.WillClose;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.enumeration.EnumerationHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.resourcebundle.XMLResourceBundleControl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@Immutable
public final class XMLResourceBundle
extends ResourceBundle {
    private final ICommonsOrderedMap<String, String> m_aValues;

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> readFromPropertiesXML(@Nonnull @WillClose InputStream inputStream) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("entry")) {
                commonsLinkedHashMap.put((Object)iMicroElement.getAttributeValue("key"), (Object)iMicroElement.getTextContent());
            }
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public static IMicroDocument getAsPropertiesXML(@Nonnull Map<String, String> map) {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement("properties");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ((IMicroElement)iMicroElement.addElement("entry").setAttribute("key", entry.getKey())).addText(entry.getValue());
        }
        return microDocument;
    }

    @DevelopersNote(value="Don't use it manually - use the static methods of this class!")
    XMLResourceBundle(@Nonnull @WillNotClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        this.m_aValues = XMLResourceBundle.readFromPropertiesXML(inputStream);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllValues() {
        return this.m_aValues.getClone();
    }

    @Override
    @CodingStyleguideUnaware
    protected Set<String> handleKeySet() {
        return this.m_aValues.keySet();
    }

    @Override
    protected String handleGetObject(@Nullable String string) {
        return (String)this.m_aValues.get((Object)string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return EnumerationHelper.getEnumeration((Iterable)this.m_aValues.keySet());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string) {
        return XMLResourceBundle.getXMLBundle(string, Locale.getDefault());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, classLoader, new XMLResourceBundleControl());
    }
}

