/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.serialize.read.XMLLoggingExceptionCallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@ThreadSafe
public final class SAXReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="RW_LOCK")
    private static DTDHandler s_aDefaultDTDHandler;
    @GuardedBy(value="RW_LOCK")
    private static ContentHandler s_aDefaultContentHandler;
    @GuardedBy(value="RW_LOCK")
    private static ErrorHandler s_aDefaultErrorHandler;
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<EXMLParserProperty, Object> DEFAULT_PROPS;
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<EXMLParserFeature, Boolean> DEFAULT_FEATURES;
    private static CallbackList<IExceptionCallback<Throwable>> s_aDefaultExceptionCallbacks;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final SAXReaderDefaultSettings INSTANCE;

    private SAXReaderDefaultSettings() {
    }

    @Nullable
    public static EntityResolver getEntityResolver() {
        return (EntityResolver)RW_LOCK.readLockedGet(() -> s_aDefaultEntityResolver);
    }

    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultEntityResolver = entityResolver;
        });
    }

    @Nullable
    public static DTDHandler getDTDHandler() {
        return (DTDHandler)RW_LOCK.readLockedGet(() -> s_aDefaultDTDHandler);
    }

    public static void setDTDHandler(@Nullable DTDHandler dTDHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultDTDHandler = dTDHandler;
        });
    }

    @Nullable
    public static ContentHandler getContentHandler() {
        return (ContentHandler)RW_LOCK.readLockedGet(() -> s_aDefaultContentHandler);
    }

    public static void setContentHandler(@Nullable ContentHandler contentHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultContentHandler = contentHandler;
        });
    }

    @Nullable
    public static ErrorHandler getErrorHandler() {
        return (ErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultErrorHandler);
    }

    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultErrorHandler = errorHandler;
        });
    }

    @Nullable
    public static LexicalHandler getLexicalHandler() {
        return (LexicalHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER);
    }

    public static void setLexicalHandler(@Nullable LexicalHandler lexicalHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER, lexicalHandler);
    }

    @Nullable
    public static DeclHandler getDeclarationHandler() {
        return (DeclHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER);
    }

    public static void setDeclarationHandler(@Nullable DeclHandler declHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER, declHandler);
    }

    public static boolean hasAnyProperties() {
        return RW_LOCK.readLockedBoolean(() -> !DEFAULT_PROPS.isEmpty());
    }

    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        return RW_LOCK.readLockedGet(() -> DEFAULT_PROPS.get((Object)eXMLParserProperty));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> DEFAULT_PROPS.getClone());
    }

    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        RW_LOCK.writeLocked(() -> {
            if (object != null) {
                DEFAULT_PROPS.put((Object)eXMLParserProperty, object);
            } else {
                DEFAULT_PROPS.remove((Object)eXMLParserProperty);
            }
        });
    }

    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null && !map.isEmpty()) {
            RW_LOCK.writeLocked(() -> DEFAULT_PROPS.putAll(map));
        }
    }

    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_PROPS.removeObject((Object)eXMLParserProperty));
    }

    @Nonnull
    public static EChange removeAllPropertyValues() {
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_PROPS.removeAll());
    }

    public static boolean hasAnyFeature() {
        return RW_LOCK.readLockedBoolean(() -> DEFAULT_FEATURES.isNotEmpty());
    }

    @Nullable
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        return (Boolean)RW_LOCK.readLockedGet(() -> (Boolean)DEFAULT_FEATURES.get((Object)eXMLParserFeature));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> DEFAULT_FEATURES.getClone());
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        RW_LOCK.writeLocked(() -> DEFAULT_FEATURES.put((Object)eXMLParserFeature, (Object)bl));
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        RW_LOCK.writeLocked(() -> {
            if (bl == null) {
                DEFAULT_FEATURES.remove((Object)eXMLParserFeature);
            } else {
                DEFAULT_FEATURES.put((Object)eXMLParserFeature, (Object)bl);
            }
        });
    }

    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null && !map.isEmpty()) {
            RW_LOCK.writeLocked(() -> DEFAULT_FEATURES.putAll(map));
        }
    }

    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_FEATURES.removeObject((Object)eXMLParserFeature));
    }

    @Nonnull
    public static EChange removeAllFeatures() {
        return (EChange)RW_LOCK.writeLockedGet(() -> DEFAULT_FEATURES.removeAll());
    }

    public static boolean requiresNewXMLParser() {
        return RW_LOCK.readLockedBoolean(() -> {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                return true;
            }
            if (!DEFAULT_PROPS.isEmpty() || !DEFAULT_FEATURES.isEmpty()) {
                return true;
            }
            return s_aDefaultEntityResolver != null;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return s_aDefaultExceptionCallbacks;
    }

    public static boolean isRequiresNewXMLParserExplicitly() {
        return RW_LOCK.readLockedBoolean(() -> s_bDefaultRequiresNewXMLParserExplicitly);
    }

    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
        });
    }

    static {
        s_aDefaultErrorHandler = new LoggingSAXErrorHandler();
        DEFAULT_PROPS = new CommonsEnumMap(EXMLParserProperty.class);
        DEFAULT_FEATURES = new CommonsEnumMap(EXMLParserFeature.class);
        s_aDefaultExceptionCallbacks = new CallbackList();
        s_aDefaultExceptionCallbacks.add((ICallback)new XMLLoggingExceptionCallback());
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        INSTANCE = new SAXReaderDefaultSettings();
    }
}

