/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.system.EJavaVersion;
import com.helger.base.system.SystemProperties;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.read.DOMReader;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class XMLSystemProperties {
    public static final String SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT = "jdk.xml.entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT = "jdk.xml.elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR = "jdk.xml.maxOccurLimit";
    public static final String SYSTEM_PROPERTY_MAX_OCCUR = "maxOccurLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT = "jdk.xml.totalEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT = "jdk.xml.maxGeneralEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT = "jdk.xml.maxParameterEntitySizeLimit";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLSystemProperties.class);
    private static final XMLSystemProperties INSTANCE = new XMLSystemProperties();

    private XMLSystemProperties() {
    }

    private static void _onSystemPropertyChange() {
        XMLFactory.reinitialize();
        DOMReader.reinitialize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("XML processing system properties changed!");
        }
    }

    public static void setXMLEntityExpansionLimit(int n) {
        XMLSystemProperties.setXMLEntityExpansionLimit(Integer.toString(n));
    }

    public static void setXMLEntityExpansionLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT, (String)string);
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLEntityExpansionLimitIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLEntityExpansionLimit();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLEntityExpansionLimit(n);
        }
    }

    public static int getXMLEntityExpansionLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
        }
        if (string == null) {
            if (EJavaVersion.getCurrentVersion().isNewerOrEqualsThan(EJavaVersion.JDK_24)) {
                return 2500;
            }
            return 64000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLElementAttributeLimit(int n) {
        XMLSystemProperties.setXMLElementAttributeLimit(Integer.toString(n));
    }

    public static void setXMLElementAttributeLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT, (String)string);
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLElementAttributeLimitIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLElementAttributeLimit();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLElementAttributeLimit(n);
        }
    }

    public static int getXMLElementAttributeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
        }
        if (string == null) {
            if (EJavaVersion.getCurrentVersion().isNewerOrEqualsThan(EJavaVersion.JDK_24)) {
                return 200;
            }
            return 10000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxOccur(int n) {
        XMLSystemProperties.setXMLMaxOccur(Integer.toString(n));
    }

    public static void setXMLMaxOccur(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_MAX_OCCUR, (String)string);
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLMaxOccurIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLMaxOccur();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLMaxOccur(n);
        }
    }

    public static int getXMLMaxOccur() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_MAX_OCCUR);
        }
        if (string == null) {
            return 5000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLTotalEntitySizeLimit(int n) {
        XMLSystemProperties.setXMLTotalEntitySizeLimit(Integer.toString(n));
    }

    public static void setXMLTotalEntitySizeLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLTotalEntitySizeLimitIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLTotalEntitySizeLimit();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLTotalEntitySizeLimit(n);
        }
    }

    public static int getXMLTotalEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            if (EJavaVersion.getCurrentVersion().isNewerOrEqualsThan(EJavaVersion.JDK_24)) {
                return 100000;
            }
            return 50000000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxGeneralEntitySizeLimit(int n) {
        XMLSystemProperties.setXMLMaxGeneralEntitySizeLimit(Integer.toString(n));
    }

    public static void setXMLMaxGeneralEntitySizeLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLMaxGeneralEntitySizeLimitIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLMaxGeneralEntitySizeLimit();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLMaxGeneralEntitySizeLimit(n);
        }
    }

    public static int getXMLMaxGeneralEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxParameterEntitySizeLimit(int n) {
        XMLSystemProperties.setXMLMaxParameterEntitySizeLimit(Integer.toString(n));
    }

    public static void setXMLMaxParameterEntitySizeLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static void setXMLMaxParameterEntitySizeLimitIfLarger(int n) {
        int n2 = XMLSystemProperties.getXMLMaxParameterEntitySizeLimit();
        if (n2 > 0 && (n <= 0 || n > n2)) {
            XMLSystemProperties.setXMLMaxParameterEntitySizeLimit(n);
        }
    }

    public static int getXMLMaxParameterEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }
}

