/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public static final ETriState DEFAULT_STANDALONE = ETriState.UNDEFINED;
    private ETriState m_eStandalone = DEFAULT_STANDALONE;

    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType iMicroDocumentType) {
        if (iMicroDocumentType != null) {
            this.appendChild(iMicroDocumentType);
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isDocumentType() || iMicroNode.isProcessingInstruction() || iMicroNode.isComment() || iMicroNode.isElement();
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        ICommonsList<IMicroNode> iCommonsList;
        if (!MicroDocument._canBeAppendedToDocumentRoot(abstractMicroNode)) {
            throw new MicroException("Cannot add nodes of type " + String.valueOf(abstractMicroNode) + " to a document");
        }
        if (abstractMicroNode.isElement() && (iCommonsList = this.directGetAllChildren()) != null && iCommonsList.isNotEmpty()) {
            for (IMicroNode iMicroNode : iCommonsList) {
                if (!iMicroNode.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + String.valueOf(iMicroNode) + " and wants to add " + String.valueOf(abstractMicroNode));
            }
        }
        super.onAppendChild(abstractMicroNode);
    }

    @Override
    @Nonnull
    public ETriState getStandalone() {
        return this.m_eStandalone;
    }

    @Override
    public void setStandalone(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Standalone");
        this.m_eStandalone = eTriState;
    }

    @Override
    @Nullable
    public IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isDocumentType()) continue;
                return (IMicroDocumentType)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isElement()) continue;
                return (IMicroElement)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IMicroDocument getClone() {
        MicroDocument microDocument = new MicroDocument();
        microDocument.setStandalone(this.m_eStandalone);
        this.forAllChildren(iMicroNode -> microDocument.appendChild((IMicroNode)iMicroNode.getClone()));
        return microDocument;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroDocument microDocument = (MicroDocument)iMicroNode;
        return this.m_eStandalone == microDocument.m_eStandalone;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Standalone", (Enum)this.m_eStandalone).getToString();
    }
}

