/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EXMLSerializeIndent implements IHasID<String>
{
    NONE("none", false, false),
    ALIGN_ONLY("align", false, true),
    INDENT_ONLY("indent", true, false),
    INDENT_AND_ALIGN("indentalign", true, true);

    private final String m_sID;
    private final boolean m_bIndent;
    private final boolean m_bAlign;

    private EXMLSerializeIndent(String string2, boolean bl, boolean bl2) {
        this.m_sID = string2;
        this.m_bAlign = bl2;
        this.m_bIndent = bl;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public boolean isIndent() {
        return this.m_bIndent;
    }

    public boolean isAlign() {
        return this.m_bAlign;
    }

    @Nonnull
    public EXMLSerializeIndent getWithoutIndent() {
        return this.m_bAlign ? ALIGN_ONLY : NONE;
    }

    @Nonnull
    public EXMLSerializeIndent getWithIndent() {
        return this.m_bAlign ? INDENT_AND_ALIGN : INDENT_ONLY;
    }

    @Nonnull
    public EXMLSerializeIndent getWithoutAlign() {
        return this.m_bIndent ? INDENT_ONLY : NONE;
    }

    @Nonnull
    public EXMLSerializeIndent getWithAlign() {
        return this.m_bIndent ? INDENT_AND_ALIGN : ALIGN_ONLY;
    }

    @Nullable
    public static EXMLSerializeIndent getFromIDOrNull(@Nullable String string) {
        return (EXMLSerializeIndent)EnumHelper.getFromIDOrNull(EXMLSerializeIndent.class, (Object)string);
    }
}

