/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.transform.AbstractTransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingTransformErrorListener
extends AbstractTransformErrorListener {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ErrorList m_aErrors = new ErrorList();

    @Override
    protected void internalLog(@Nonnull IError iError) {
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aErrors.add((Object)iError));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getErrorList() {
        return (ErrorList)this.m_aRWLock.readLockedGet(() -> ((ErrorList)this.m_aErrors).getClone());
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> ((ErrorList)this.m_aErrors).removeAll());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("errors", (Object)this.m_aErrors).getToString();
    }
}

