/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.Nonempty;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.ISimpleURL;
import com.helger.url.ReadOnlyURL;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

public class URLBuilder
implements IBuilder<ISimpleURL> {
    private final URLData m_aData;

    public URLBuilder() {
        this.m_aData = URLData.createEmpty();
    }

    protected URLBuilder(@Nonnull URLData uRLData) {
        this.m_aData = uRLData;
    }

    @Nonnull
    public IURLData urlData() {
        return this.m_aData;
    }

    @Nonnull
    public URLBuilder path(@Nonnull String string) {
        this.m_aData.setPath(string);
        return this;
    }

    @Nonnull
    public URLBuilder params(@Nullable Map<String, String> map) {
        this.m_aData.params().removeAll();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addParam(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public URLBuilder params(@Nullable ICommonsList<URLParameter> iCommonsList) {
        this.m_aData.setParams((ICommonsList)iCommonsList);
        return this;
    }

    @Nonnull
    public URLBuilder addParam(@Nonnull @Nonempty String string, boolean bl) {
        return this.addParam(string, Boolean.toString(bl));
    }

    @Nonnull
    public URLBuilder addParam(@Nonnull @Nonempty String string, int n) {
        return this.addParam(string, Integer.toString(n));
    }

    @Nonnull
    public URLBuilder addParam(@Nonnull @Nonempty String string, long l) {
        return this.addParam(string, Long.toString(l));
    }

    @Nonnull
    public URLBuilder addParam(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.addParam(new URLParameter(string, string2));
    }

    @Nonnull
    public URLBuilder addParam(@Nonnull URLParameter uRLParameter) {
        ValueEnforcer.notNull((Object)uRLParameter, (String)"Param");
        this.m_aData.params().add((Object)uRLParameter);
        return this;
    }

    @Nonnull
    public URLBuilder removeParam(@Nonnull @Nonempty String string) {
        this.m_aData.params().removeIf(uRLParameter -> uRLParameter.hasName(string));
        return this;
    }

    @Nonnull
    public URLBuilder param(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.removeParam(string);
        return this.addParam(string, string2);
    }

    @Nonnull
    public URLBuilder param(@Nonnull URLParameter uRLParameter) {
        ValueEnforcer.notNull((Object)uRLParameter, (String)"Param");
        this.removeParam(uRLParameter.getName());
        return this.addParam(uRLParameter);
    }

    @Nonnull
    public URLBuilder anchor(@Nullable String string) {
        this.m_aData.setAnchor(string);
        return this;
    }

    @Nonnull
    public URLBuilder charset(@Nullable Charset charset) {
        this.m_aData.setCharset(charset);
        return this;
    }

    @Nonnull
    public ISimpleURL build() {
        return new ReadOnlyURL(this.m_aData);
    }

    @Nonnull
    public static URLBuilder of(@Nullable IURLData iURLData) {
        return iURLData == null ? new URLBuilder() : new URLBuilder(new URLData(iURLData));
    }

    @Nonnull
    public static URLBuilder of(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return new URLBuilder();
        }
        return new URLBuilder(SimpleURLHelper.getAsURLData(string, URLData.DEFAULT_CHARSET));
    }

    @Nonnull
    public static URLBuilder of(@Nullable URL uRL) {
        return URLBuilder.of(uRL == null ? null : uRL.toExternalForm());
    }

    @Nonnull
    public static URLBuilder of(@Nullable URI uRI) {
        return URLBuilder.of(uRI == null ? null : uRI.toString());
    }
}

