/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.base.url.URLHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.param.URLParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

public interface ISimpleURL
extends IURLData {
    @Nonnull
    public ISimpleURL getWithPath(@Nonnull String var1);

    @Nonnull
    public ISimpleURL getWithParams(@Nullable ICommonsList<URLParameter> var1);

    @Nonnull
    public ISimpleURL getWithAnchor(@Nullable String var1);

    @Nonnull
    public ISimpleURL getWithCharset(@Nullable Charset var1);

    @Nonnull
    default public String getAsString() {
        return SimpleURLHelper.getURLString(this);
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    @Nonnull
    default public String getAsStringWithEncodedParameters() {
        return this.getAsString();
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    @Nonnull
    default public String getAsStringWithEncodedParameters(@Nullable Charset charset) {
        return this.getWithCharset(charset).getAsString();
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    @Nonnull
    default public String getAsStringWithoutEncodedParameters() {
        return this.getAsString();
    }

    @Nullable
    default public URL getAsURL() {
        return URLHelper.getAsURL((String)this.getAsString());
    }

    @Nullable
    default public URI getAsURI() {
        return URLHelper.getAsURI((String)this.getAsString());
    }
}

