/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.protocol;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.url.protocol.IURLProtocol;
import com.helger.url.protocol.URLProtocolRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class URLProtocol
implements IURLProtocol {
    private final String m_sProtocol;
    private final boolean m_bAllowsForQueryParameters;

    public URLProtocol(@Nonnull @Nonempty String string, boolean bl) {
        this.m_sProtocol = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Protocol");
        this.m_bAllowsForQueryParameters = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String string) {
        return string != null && string.startsWith(this.m_sProtocol);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_sProtocol + string;
    }

    @Nullable
    public String getWithProtocolIfNone(@Nullable String string) {
        if (string == null || URLProtocolRegistry.getInstance().hasKnownProtocol(string)) {
            return string;
        }
        return this.m_sProtocol + string;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this.m_bAllowsForQueryParameters;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLProtocol uRLProtocol = (URLProtocol)object;
        return this.m_sProtocol.equals(uRLProtocol.m_sProtocol) && this.m_bAllowsForQueryParameters == uRLProtocol.m_bAllowsForQueryParameters;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProtocol).append(this.m_bAllowsForQueryParameters).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("protocol", (Object)this.m_sProtocol).append("queryParams", this.m_bAllowsForQueryParameters).getToString();
    }
}

