/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURLHelper;
import com.helger.url.codec.URLParameterDecoder;
import com.helger.url.data.IMutableURLData;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

@NotThreadSafe
public class SimpleURL
implements ISimpleURL,
IMutableURLData<SimpleURL>,
ICloneable<SimpleURL> {
    private final URLData m_aData;

    public SimpleURL() {
        this.m_aData = URLData.createEmpty();
    }

    public SimpleURL(@Nonnull URL uRL) {
        this(uRL, URLData.DEFAULT_CHARSET);
    }

    public SimpleURL(@Nonnull URL uRL, @Nonnull Charset charset) {
        this(uRL.toExternalForm(), charset);
    }

    public SimpleURL(@Nonnull URI uRI) {
        this(uRI, URLData.DEFAULT_CHARSET);
    }

    public SimpleURL(@Nonnull URI uRI, @Nonnull Charset charset) {
        this(uRI.toString(), charset);
    }

    public SimpleURL(@Nonnull IURLData iURLData) {
        this.m_aData = new URLData(iURLData);
    }

    public SimpleURL(@Nonnull String string) {
        this(string, URLData.DEFAULT_CHARSET);
    }

    public SimpleURL(@Nonnull String string, @Nullable Charset charset) {
        this(SimpleURLHelper.getAsURLData(string, charset, charset == null ? null : new URLParameterDecoder(charset)));
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string, map, null);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        if (StringHelper.isNotEmpty((String)string2)) {
            this.m_aData.setAnchor(string2);
        }
    }

    public SimpleURL(@Nonnull String string, @Nullable Iterable<URLParameter> iterable) {
        this(string, iterable, null);
    }

    public SimpleURL(@Nonnull String string, @Nullable Iterable<URLParameter> iterable, @Nullable String string2) {
        this(string);
        this.m_aData.params().addAll(iterable);
        if (StringHelper.isNotEmpty((String)string2)) {
            this.m_aData.setAnchor(string2);
        }
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_aData.getPath();
    }

    @Override
    @Nonnull
    public SimpleURL setPath(@Nonnull String string) {
        this.m_aData.setPath(string);
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<URLParameter> params() {
        return this.m_aData.params();
    }

    @Override
    @Nullable
    public String getFirstParamValue(@Nullable String string) {
        return this.m_aData.getFirstParamValue(string);
    }

    @Override
    @Nonnull
    public SimpleURL setParams(@Nullable ICommonsList<URLParameter> iCommonsList) {
        this.m_aData.setParams((ICommonsList)iCommonsList);
        return this;
    }

    @Nonnull
    public SimpleURL withParams(@Nonnull Consumer<? super ICommonsList<URLParameter>> consumer) {
        ValueEnforcer.notNull(consumer, (String)"ParamConsumer");
        consumer.accept((ICommonsList<URLParameter>)this.m_aData.params());
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string) {
        this.m_aData.params().add((Object)new URLParameter(string));
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, boolean bl) {
        this.add(string, Boolean.toString(bl));
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, int n) {
        this.add(string, Integer.toString(n));
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, long l) {
        this.add(string, Long.toString(l));
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aData.params().add((Object)new URLParameter(string, StringHelper.getNotNull((String)string2)));
        return this;
    }

    @Nonnull
    public SimpleURL addIfNotNull(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addIf(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Predicate<String> predicate) {
        if (predicate.test(string2)) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addAll(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_aData.getAnchor();
    }

    @Override
    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_aData.setAnchor(string);
        return this;
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aData.getCharset();
    }

    @Override
    @Nonnull
    public SimpleURL setCharset(@Nullable Charset charset) {
        this.m_aData.setCharset(charset);
        return this;
    }

    @Override
    @Nonnull
    public final SimpleURL getWithPath(@Nonnull String string) {
        if (this.m_aData.getPath().equals(string)) {
            return this;
        }
        return new SimpleURL(this.m_aData.getClone().setPath(string));
    }

    @Override
    @Nonnull
    public final SimpleURL getWithParams(@Nullable ICommonsList<URLParameter> iCommonsList) {
        if (EqualsHelper.equals(this.m_aData.params(), iCommonsList)) {
            return this;
        }
        return new SimpleURL(this.m_aData.getClone().setParams((ICommonsList)iCommonsList));
    }

    @Override
    @Nonnull
    public final SimpleURL getWithAnchor(@Nullable String string) {
        if (this.m_aData.hasAnchor(string)) {
            return this;
        }
        return new SimpleURL(this.m_aData.getClone().setAnchor(string));
    }

    @Override
    @Nonnull
    public final SimpleURL getWithCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals((Object)this.m_aData.getCharset(), (Object)charset)) {
            return this;
        }
        return new SimpleURL(this.m_aData.getClone().setCharset(charset));
    }

    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleURL simpleURL = (SimpleURL)object;
        return this.m_aData.equals(simpleURL.m_aData);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Data", (Object)this.m_aData).getToString();
    }
}

