/*
 * Decompiled with CFR 0.152.
 */
package com.helger.unittestext;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.reflection.GenericReflection;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import com.helger.typeconvert.trait.IGetterDirectTrait;
import com.helger.typeconvert.util.ClassHierarchyCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CommonsMock {
    private static final Map<Class<?>, MockSupplier> STATIC_SUPPLIERS = new WeakHashMap();
    private final Map<Class<?>, MockSupplier> m_aPerInstanceSupplier = new WeakHashMap();

    private static boolean _canRegister(Class<?> clazz) {
        return clazz != Object.class;
    }

    public static <T> void registerStaticConstant(@Nonnull T t) {
        CommonsMock.registerStatic(MockSupplier.createConstant(t));
    }

    public static <T> void registerStatic(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
        CommonsMock.registerStatic(MockSupplier.createNoParams(clazz, supplier));
    }

    public static <T> void registerStatic(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
        CommonsMock.registerStatic(MockSupplier.create(clazz, paramArray, function));
    }

    private static void _register(@Nonnull MockSupplier mockSupplier, @Nonnull Map<Class<?>, MockSupplier> map) {
        ValueEnforcer.notNull((Object)mockSupplier, (String)"Supplier");
        ValueEnforcer.notNull(map, (String)"TargetMap");
        Class<?> clazz2 = mockSupplier.m_aDstClass;
        if (map.containsKey(clazz2)) {
            throw new IllegalArgumentException("A static for class " + clazz2.getName() + " is already contained!");
        }
        for (Class clazz3 : ClassHierarchyCache.getClassHierarchy(clazz2)) {
            if (!CommonsMock._canRegister(clazz3)) continue;
            map.computeIfAbsent(clazz3, clazz -> mockSupplier);
        }
    }

    public static void registerStatic(@Nonnull MockSupplier mockSupplier) {
        CommonsMock._register(mockSupplier, STATIC_SUPPLIERS);
    }

    public <T> void registerPerInstanceConstant(@Nonnull T t) {
        this.registerPerInstance(MockSupplier.createConstant(t));
    }

    public <T> void registerPerInstance(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
        this.registerPerInstance(MockSupplier.createNoParams(clazz, supplier));
    }

    public <T> void registerPerInstance(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
        this.registerPerInstance(MockSupplier.create(clazz, paramArray, function));
    }

    public void registerPerInstance(@Nonnull MockSupplier mockSupplier) {
        CommonsMock._register(mockSupplier, this.m_aPerInstanceSupplier);
    }

    @Nonnull
    private Object _mock(@Nonnull Class<?> clazz, @Nullable Object[] objectArray, int n) throws Exception {
        MockSupplier mockSupplier = STATIC_SUPPLIERS.get(clazz);
        if (mockSupplier != null) {
            return mockSupplier.getMockedValue(objectArray);
        }
        MockSupplier mockSupplier2 = this.m_aPerInstanceSupplier.get(clazz);
        if (mockSupplier2 != null) {
            return mockSupplier2.getMockedValue(objectArray);
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == Boolean.TYPE) {
                return ArrayHelper.createBooleanArray((boolean[])new boolean[0]);
            }
            if (clazz2 == Byte.TYPE) {
                return ArrayHelper.createByteArray((byte[])new byte[0]);
            }
            if (clazz2 == Character.TYPE) {
                return ArrayHelper.createCharArray((char[])new char[0]);
            }
            if (clazz2 == Double.TYPE) {
                return ArrayHelper.createDoubleArray((double[])new double[0]);
            }
            if (clazz2 == Float.TYPE) {
                return ArrayHelper.createFloatArray((float[])new float[0]);
            }
            if (clazz2 == Integer.TYPE) {
                return ArrayHelper.createIntArray((int[])new int[0]);
            }
            if (clazz2 == Long.TYPE) {
                return ArrayHelper.createLongArray((long[])new long[0]);
            }
            if (clazz2 == Short.TYPE) {
                return ArrayHelper.createShortArray((short[])new short[0]);
            }
            Object[] objectArray2 = ArrayHelper.createArray(clazz2, (int)1);
            objectArray2[0] = this._mock(clazz2, null, n + 1);
            return objectArray2;
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            try {
                Object[] objectArray3 = new Object[constructor.getParameterCount()];
                int n2 = 0;
                for (Class<?> clazz3 : constructor.getParameterTypes()) {
                    objectArray3[n2++] = EqualsHelper.identityEqual(clazz3, clazz) ? null : this._mock(clazz3, null, n + 1);
                }
                return constructor.newInstance(objectArray3);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Class " + clazz.getName() + " has no mockable constructor!");
    }

    @Nonnull
    public <T> T mock(@Nonnull Class<T> clazz, Object ... objectArray) {
        try {
            Object object = GenericReflection.uncheckedCast((Object)this._mock(clazz, objectArray, 0));
            if (!this.m_aPerInstanceSupplier.containsKey(clazz)) {
                this.registerPerInstanceConstant(object);
            }
            return (T)object;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to mock class " + clazz.getName(), exception);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public <T> ICommonsList<T> mockMany(@Nonnegative int n, @Nonnull Class<T> clazz, Object ... objectArray) {
        CommonsArrayList commonsArrayList = new CommonsArrayList(n);
        for (int i = 0; i < n; ++i) {
            commonsArrayList.add(this.mock(clazz, objectArray));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public <T> ICommonsSet<T> mockSet(@Nonnegative int n, @Nonnull Class<T> clazz, Object ... objectArray) {
        CommonsHashSet commonsHashSet = new CommonsHashSet(n);
        for (int i = 0; i < n; ++i) {
            commonsHashSet.add(this.mock(clazz, objectArray));
        }
        return commonsHashSet;
    }

    static {
        STATIC_SUPPLIERS.put(Boolean.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_BOOLEAN_OBJ));
        STATIC_SUPPLIERS.put(Boolean.class, MockSupplier.createConstant(CGlobal.DEFAULT_BOOLEAN_OBJ));
        STATIC_SUPPLIERS.put(Byte.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_BYTE_OBJ));
        STATIC_SUPPLIERS.put(Byte.class, MockSupplier.createConstant(CGlobal.DEFAULT_BYTE_OBJ));
        STATIC_SUPPLIERS.put(Character.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_CHAR_OBJ));
        STATIC_SUPPLIERS.put(Character.class, MockSupplier.createConstant(CGlobal.DEFAULT_CHAR_OBJ));
        STATIC_SUPPLIERS.put(Double.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_DOUBLE_OBJ));
        STATIC_SUPPLIERS.put(Double.class, MockSupplier.createConstant(CGlobal.DEFAULT_DOUBLE_OBJ));
        STATIC_SUPPLIERS.put(Float.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_FLOAT_OBJ));
        STATIC_SUPPLIERS.put(Float.class, MockSupplier.createConstant(CGlobal.DEFAULT_FLOAT_OBJ));
        STATIC_SUPPLIERS.put(Integer.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_INT_OBJ));
        STATIC_SUPPLIERS.put(Integer.class, MockSupplier.createConstant(CGlobal.DEFAULT_INT_OBJ));
        STATIC_SUPPLIERS.put(Long.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_LONG_OBJ));
        STATIC_SUPPLIERS.put(Long.class, MockSupplier.createConstant(CGlobal.DEFAULT_LONG_OBJ));
        STATIC_SUPPLIERS.put(Short.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_SHORT_OBJ));
        STATIC_SUPPLIERS.put(Short.class, MockSupplier.createConstant(CGlobal.DEFAULT_SHORT_OBJ));
        Supplier<String> supplier = new Supplier<String>(){
            private final AtomicInteger m_aCount = new AtomicInteger(0);

            @Override
            @Nonnull
            @Nonempty
            public String get() {
                return "str" + this.m_aCount.incrementAndGet();
            }
        };
        CommonsMock.registerStatic(String.class, supplier);
        CommonsMock.registerStatic(LocalDate.class, PDTFactory::getCurrentLocalDate);
        CommonsMock.registerStatic(OffsetDate.class, PDTFactory::getCurrentOffsetDate);
        CommonsMock.registerStatic(XMLOffsetDate.class, PDTFactory::getCurrentXMLOffsetDate);
        CommonsMock.registerStatic(LocalTime.class, PDTFactory::getCurrentLocalTime);
        CommonsMock.registerStatic(OffsetTime.class, PDTFactory::getCurrentOffsetTime);
        CommonsMock.registerStatic(XMLOffsetTime.class, PDTFactory::getCurrentXMLOffsetTime);
        CommonsMock.registerStatic(LocalDateTime.class, PDTFactory::getCurrentLocalDateTime);
        CommonsMock.registerStatic(OffsetDateTime.class, PDTFactory::getCurrentOffsetDateTime);
        CommonsMock.registerStatic(XMLOffsetDateTime.class, PDTFactory::getCurrentXMLOffsetDateTime);
        CommonsMock.registerStatic(ZonedDateTime.class, PDTFactory::getCurrentZonedDateTime);
        CommonsMock.registerStaticConstant(BigDecimal.ZERO);
        CommonsMock.registerStaticConstant(BigInteger.ZERO);
    }

    private static final class MockSupplier {
        private final Class<?> m_aDstClass;
        private final Param[] m_aParams;
        private final Function<IGetterDirectTrait[], ?> m_aFct;

        private MockSupplier(@Nonnull Class<?> clazz, @Nullable Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], ?> function) {
            this.m_aDstClass = clazz;
            this.m_aParams = paramArray;
            this.m_aFct = function;
        }

        @Nullable
        public Object getMockedValue(@Nullable Object[] objectArray) {
            IGetterDirectTrait[] iGetterDirectTraitArray = null;
            if (this.m_aParams != null && this.m_aParams.length > 0) {
                int n = this.m_aParams.length;
                int n2 = ArrayHelper.getSize((Object[])objectArray);
                iGetterDirectTraitArray = new IGetterDirectTrait[n];
                for (int i = 0; i < n; ++i) {
                    if (i < n2 && objectArray[i] != null) {
                        Object object = objectArray[i];
                        iGetterDirectTraitArray[i] = () -> object;
                        continue;
                    }
                    iGetterDirectTraitArray[i] = this.m_aParams[i].getDefaultValue();
                }
            }
            return this.m_aFct.apply(iGetterDirectTraitArray);
        }

        @Nonnull
        public static MockSupplier createConstant(@Nonnull Object object) {
            ValueEnforcer.notNull((Object)object, (String)"Constant");
            return new MockSupplier(object.getClass(), null, iGetterDirectTraitArray -> object);
        }

        @Nonnull
        public static <T> MockSupplier createNoParams(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
            ValueEnforcer.notNull(clazz, (String)"DstClass");
            ValueEnforcer.notNull(supplier, (String)"Supplier");
            return new MockSupplier(clazz, null, iGetterDirectTraitArray -> supplier.get());
        }

        @Nonnull
        public static <T> MockSupplier create(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
            ValueEnforcer.notNull(clazz, (String)"DstClass");
            ValueEnforcer.notNull((Object)paramArray, (String)"Params");
            ValueEnforcer.notNull(function, (String)"Supplier");
            return new MockSupplier(clazz, paramArray, function);
        }
    }

    @Immutable
    public static final class Param {
        private final String m_sParamName;
        private final Class<?> m_aParamClass;
        private final Supplier<?> m_aDefaultValueSupplier;

        public <T> Param(@Nonnull @Nonempty String string, @Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
            this.m_sParamName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ParamName");
            this.m_aParamClass = (Class)ValueEnforcer.notNull(clazz, (String)"ParamClass");
            this.m_aDefaultValueSupplier = (Supplier)ValueEnforcer.notNull(supplier, (String)"DefaultValueSupplier");
        }

        @Nonnull
        @Nonempty
        public String getParamName() {
            return this.m_sParamName;
        }

        @Nonnull
        public Class<?> getParamClass() {
            return this.m_aParamClass;
        }

        @Nonnull
        public IGetterDirectTrait getDefaultValue() {
            Object obj = this.m_aDefaultValueSupplier.get();
            return () -> obj;
        }

        public String toString() {
            return ClassHelper.getClassLocalName(this.m_aParamClass) + ":" + this.m_sParamName;
        }

        @Nonnull
        public static Param createConstant(@Nonnull @Nonempty String string, boolean bl) {
            return Param.createConstant(string, Boolean.TYPE, bl);
        }

        @Nonnull
        public static <T> Param createConstant(@Nonnull @Nonempty String string, @Nonnull Class<T> clazz, @Nullable T t) {
            return new Param(string, clazz, () -> t);
        }
    }
}

