/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.withid.unique;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsList;
import com.helger.tree.withid.BasicTreeWithID;
import com.helger.tree.withid.ITreeItemWithID;
import com.helger.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import com.helger.tree.withid.unique.ITreeWithGlobalUniqueID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class BasicTreeWithGlobalUniqueID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
extends BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE>
implements ITreeWithGlobalUniqueID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> m_aFactory;

    public BasicTreeWithGlobalUniqueID(@NonNull ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithUniqueIDFactory) {
        super(iTreeItemWithUniqueIDFactory);
        this.m_aFactory = iTreeItemWithUniqueIDFactory;
    }

    protected final @NonNull ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @Override
    public final boolean containsItemWithID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aFactory.containsItemWithDataID(KEYTYPE);
    }

    @Override
    public final @Nullable ITEMTYPE getItemWithID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aFactory.getItemOfDataID(KEYTYPE);
    }

    @Override
    public final @Nullable DATATYPE getItemDataWithID(@Nullable KEYTYPE KEYTYPE) {
        ITEMTYPE ITEMTYPE = this.getItemWithID(KEYTYPE);
        return ITEMTYPE == null ? null : (DATATYPE)ITEMTYPE.getData();
    }

    public final @Nullable ITEMTYPE getChildWithID(@Nullable ITEMTYPE ITEMTYPE, @Nullable KEYTYPE KEYTYPE) {
        Object object = ITEMTYPE != null ? ITEMTYPE : this.getRootItem();
        return object.getChildItemOfDataID(KEYTYPE);
    }

    @Override
    @Nonnegative
    public final int getItemCount() {
        return this.m_aFactory.getItemCount();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsCollection<ITEMTYPE> getAllItems() {
        return this.m_aFactory.getAllItems();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsCollection<DATATYPE> getAllItemDatas() {
        return this.m_aFactory.getAllItemDatas();
    }

    @Override
    public final @NonNull EChange removeItemWithID(@Nullable KEYTYPE KEYTYPE) {
        ITEMTYPE ITEMTYPE = this.getItemWithID(KEYTYPE);
        if (ITEMTYPE == null) {
            return EChange.UNCHANGED;
        }
        ITreeItemWithID iTreeItemWithID = (ITreeItemWithID)ITEMTYPE.getParent();
        if (iTreeItemWithID == null) {
            throw new IllegalArgumentException("Cannot remove the root item!");
        }
        if (iTreeItemWithID.removeChild(KEYTYPE).isUnchanged()) {
            throw new IllegalStateException("Failed to remove child " + String.valueOf(ITEMTYPE) + " from parent " + String.valueOf(iTreeItemWithID));
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean isItemSameOrDescendant(@Nullable KEYTYPE KEYTYPE, @Nullable KEYTYPE KEYTYPE2) {
        ITEMTYPE ITEMTYPE = this.getItemWithID(KEYTYPE);
        if (ITEMTYPE == null) {
            return false;
        }
        ITEMTYPE ITEMTYPE2 = this.getItemWithID(KEYTYPE2);
        return ITEMTYPE2 != null && ITEMTYPE2.isSameOrChildOf(ITEMTYPE);
    }

    public boolean hasChildren(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().hasChildren() : ITEMTYPE.hasChildren();
    }

    @Nonnegative
    public int getChildCount(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().getChildCount() : ITEMTYPE.getChildCount();
    }

    public @Nullable ICommonsList<? extends ITEMTYPE> getAllChildren(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().getAllChildren() : ITEMTYPE.getAllChildren();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasicTreeWithGlobalUniqueID basicTreeWithGlobalUniqueID = (BasicTreeWithGlobalUniqueID)object;
        return this.m_aFactory.equals(basicTreeWithGlobalUniqueID.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("factory", this.m_aFactory).getToString();
    }
}

